/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.jface;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class JFaceComponent {
    private TableViewer viewer = null;

    public JFaceComponent() {
    }

    public JFaceComponent(Composite composite) {
        this.viewer = new TableViewer(composite);
    }

    public JFaceComponent(Table table) {
        this.viewer = new TableViewer(table);
    }

    public void configureViewer() {
        this.setContentProvider((IContentProvider)new ViewContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
    }

    public void setInput(Object object) {
        this.viewer.setInput(object);
    }

    public void setContentProvider(IContentProvider provider) {
        this.viewer.setContentProvider(provider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.viewer.setLabelProvider(labelProvider);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void update(Object element, String[] properties) {
        this.viewer.update(element, properties);
    }

    public void update(Object[] elements, String[] properties) {
        this.viewer.update(elements, properties);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    IResourceChangeListener {
        private IResource input;

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            System.out.println("Viewer-> ContentProvider.inputChanged() - Input: " + newInput);
            if (oldInput == null) {
                IResource cfr_ignored_0 = (IResource)newInput;
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            }
            this.input = (IResource)newInput;
        }

        public void dispose() {
            System.out.println("In content provider dispose");
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public Object[] getElements(Object parent) {
            System.out.println("Viewer-> ContentProvider.getElements() - for parent: " + parent);
            return this.getViewElements();
        }

        private Object[] getViewElements() {
            if (this.input instanceof IContainer) {
                IContainer inputContainer = (IContainer)this.input;
                Object[] members = null;
                try {
                    members = inputContainer.members();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (members.length != 0) {
                    return members;
                }
            }
            return new String[]{"no members to display"};
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            Control ctrl = JFaceComponent.this.viewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                ctrl.getDisplay().syncExec(new Runnable(this, delta){
                    final /* synthetic */ ViewContentProvider this$1;
                    private final /* synthetic */ IResourceDelta val$delta;
                    {
                        this.this$1 = viewContentProvider;
                        this.val$delta = iResourceDelta;
                    }

                    public void run() {
                        this.this$1.processResourceChangeDelta(this.val$delta);
                    }
                });
            }
        }

        protected void processResourceChangeDelta(IResourceDelta delta) {
            JFaceComponent.this.viewer.refresh();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ILabelProvider,
    ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof IResource) {
                IResource res = (IResource)obj;
                if (index == 0) {
                    return res.getName();
                }
                return res.toString();
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return this.getImage(obj);
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (obj instanceof IResource) {
                IResource res = (IResource)obj;
                switch (res.getType()) {
                    case 4: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                    }
                    case 2: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                    }
                    case 1: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                    }
                }
            }
            return null;
        }
    }
}

