/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.newWizard;

import com.ibm.lab.soln.newWizard.CustomProjectFilePage;
import com.ibm.lab.soln.newWizard.CustomWizardNewProjectCreationPage;
import com.ibm.lab.soln.newWizard.NewWizardPlugin;
import com.ibm.lab.soln.newWizard.ProjectCustomizer;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CustomProjectWizard
extends Wizard
implements INewWizard {
    private CustomWizardNewProjectCreationPage projectPage;
    private CustomProjectFilePage filePage;

    public boolean performFinish() {
        final IProject newProject = this.projectPage.getProjectHandle();
        final IPath projectLoc = this.getProjectLocation();
        final boolean needsCustomized = this.projectPage.needfilePage.getSelection();
        final boolean log = this.filePage.loggingFile.getSelection();
        final boolean readme = this.filePage.readmeFile.getSelection();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.beginTask("Create Customized Project:", 3000);
                monitor.subTask("prepare");
                monitor.worked(1000);
                ProjectCustomizer.pause(1000L);
                CustomProjectWizard.this.createProject(newProject, projectLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (newProject.exists() && needsCustomized) {
                    monitor.subTask("customize");
                    ProjectCustomizer.pause(1000L);
                    CustomProjectWizard.this.customizeProject(newProject, log, readme, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return newProject.exists();
    }

    private IPath getProjectLocation() {
        IPath projectLoc = null;
        if (!this.projectPage.useDefaults()) {
            projectLoc = this.projectPage.getLocationPath();
        }
        return projectLoc;
    }

    private void createProject(IProject newProject, IPath projectLoc, IProgressMonitor monitor) {
        monitor.beginTask("", 500);
        monitor.subTask("create project description");
        IProjectDescription projectDesc = NewWizardPlugin.getWorkspace().newProjectDescription(newProject.getName());
        projectDesc.setLocation(projectLoc);
        monitor.worked(100);
        ProjectCustomizer.pause(1000L);
        try {
            monitor.subTask("create project");
            newProject.create(projectDesc, monitor);
            monitor.worked(100);
            ProjectCustomizer.pause(1000L);
            monitor.subTask("open the new project");
            newProject.open(monitor);
            monitor.worked(100);
            ProjectCustomizer.pause(1000L);
            monitor.done();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void customizeProject(IProject project, boolean log, boolean readme, IProgressMonitor monitor) {
        monitor.beginTask("", 3000);
        monitor.subTask("add folder");
        IFolder readmeFolder = ProjectCustomizer.createFolder((IContainer)project, "readme");
        monitor.worked(1000);
        ProjectCustomizer.pause(1000L);
        monitor.subTask("add log file");
        if (log) {
            ProjectCustomizer.createChangeLogFile((IContainer)project, "Change_log.txt");
        }
        monitor.worked(1000);
        ProjectCustomizer.pause(1000L);
        monitor.subTask("add readme file");
        if (readme) {
            Path template = new Path("readme_template/readme_file_template.readme");
            String fileName = String.valueOf(project.getName()) + ".readme";
            ProjectCustomizer.copyTemplate(readmeFolder, fileName, (IPath)template);
        }
        monitor.worked(1000);
        ProjectCustomizer.pause(1000L);
        monitor.done();
    }

    public void addPages() {
        this.projectPage = new CustomWizardNewProjectCreationPage("projectPage");
        this.projectPage.setTitle("Create a New Project");
        this.projectPage.setDescription("Enter name and optional custom location for a project");
        this.addPage((IWizardPage)this.projectPage);
        this.filePage = new CustomProjectFilePage("filePage", "Generated Project Files", null);
        this.filePage.setDescription("Select the files to be added to the project.");
        this.filePage.setPageComplete(false);
        this.addPage((IWizardPage)this.filePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Create New Custom Project");
        this.setNeedsProgressMonitor(true);
    }

    public CustomProjectFilePage getFilePage() {
        return this.filePage;
    }
}

