/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.sqleditor.sql;

import com.ibm.lab.soln.sqleditor.SQLEditorPlugin;
import com.ibm.lab.soln.sqleditor.sql.ISQLSyntax;
import com.ibm.lab.soln.sqleditor.utils.ColorProvider;
import com.ibm.lab.soln.sqleditor.utils.SQLWhiteSpaceDetector;
import com.ibm.lab.soln.sqleditor.utils.SQLWordDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class SQLCodeScanner
extends RuleBasedScanner
implements ISQLSyntax {
    public SQLCodeScanner() {
        ColorProvider provider = SQLEditorPlugin.getDefault().getColorProvider();
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(ColorProvider.KEYWORD), provider.getColor(ColorProvider.BACKGROUND), 1));
        Token type = new Token((Object)new TextAttribute(provider.getColor(ColorProvider.TYPE), provider.getColor(ColorProvider.BACKGROUND), 1));
        Token string = new Token((Object)new TextAttribute(provider.getColor(ColorProvider.STRING)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(ColorProvider.SINGLE_LINE_COMMENT)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(ColorProvider.DEFAULT)));
        this.setDefaultReturnToken((IToken)other);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new SQLWhiteSpaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new SQLWordDetector(), (IToken)other);
        int i = 0;
        while (i < ISQLSyntax.reservedwords.length) {
            wordRule.addWord(ISQLSyntax.reservedwords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < ISQLSyntax.types.length) {
            wordRule.addWord(ISQLSyntax.types[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < ISQLSyntax.constants.length) {
            wordRule.addWord(ISQLSyntax.constants[i], (IToken)type);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

