/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources.nature_builder;

import com.ibm.lab.soln.resources.EDUResourcesPlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CustomNature
implements IProjectNature {
    private IProject project;
    private boolean traceEnabled = true;

    public void configure() throws CoreException {
        this.addReadmeBuilderToBuildSpec(this.project);
    }

    public void addReadmeBuilderToBuildSpec(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("com.ibm.lab.soln.resources.readmebuilder")) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = desc.newCommand();
            command.setBuilderName("com.ibm.lab.soln.resources.readmebuilder");
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, null);
            this.resultInformation("Soln: Resource - Add ReadmeBuilder Request", "ReadmeBuilder was added.");
        } else {
            this.resultError("Soln: Resource - Add ReadmeBuilder Request", "Error adding the ReadmeBuilder to the project.");
        }
    }

    protected void resultError(String title, String msg) {
        if (this.traceEnabled) {
            System.out.println(String.valueOf(title) + msg);
        } else {
            Shell shell = EDUResourcesPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
        }
    }

    protected void resultInformation(String title, String msg) {
        if (this.traceEnabled) {
            System.out.println(String.valueOf(title) + msg);
        } else {
            Shell shell = EDUResourcesPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
        }
    }

    void traceMsg(String msg) {
        if (this.traceEnabled) {
            System.out.println(msg);
        }
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject value) {
        this.project = value;
    }
}

