/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources.nature_builder;

import com.ibm.lab.soln.resources.ActionResourceAction;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;

public class ActionAddBuilderToProject
extends ActionResourceAction {
    public void run(IAction action) {
        IProject project = (IProject)this.selection.iterator().next();
        try {
            if (this.hasNature("com.ibm.lab.soln.resources.readmebuilder") && this.resultQuestion("Soln: Resource - Add ReadmeBuilder Request", "ReadmeBuilder spec says hasNature=\"true\", may not be able to add to project. Try anyway?")) {
                this.addToBuildSpec(project);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.resultError("Soln: Resource - Add ReadmeBuilder Request", "Error adding the ReadmeBuilder to the project.");
        }
    }

    public void addToBuildSpec(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = this.hasBuilder(commands);
        if (!found) {
            ICommand command = desc.newCommand();
            command.setBuilderName("com.ibm.lab.soln.resources.readmebuilder");
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, null);
            if (this.hasBuilder(project.getDescription().getBuildSpec())) {
                this.resultInformation("Soln: Resource - Add ReadmeBuilder Request", "ReadmeBuilder was added.");
            } else {
                this.resultError("Soln: Resource - Add ReadmeBuilder Request", "Builder not added, Nature that references builder may exist.");
            }
        } else {
            this.resultError("Soln: Resource - Add ReadmeBuilder Request", "ReadmeBuilder already exists in the project.");
        }
    }

    public boolean hasBuilder(ICommand[] commands) {
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("com.ibm.lab.soln.resources.readmebuilder")) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    public boolean hasNature(String builderName) {
        IExtension extension = Platform.getPluginRegistry().getExtension("org.eclipse.core.resources", "builders", builderName);
        if (extension == null) {
            return false;
        }
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            return false;
        }
        String hasNature = configs[0].getAttribute("hasNature");
        return hasNature != null && hasNature.equalsIgnoreCase(Boolean.TRUE.toString());
    }
}

