/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources.markers;

import com.ibm.lab.soln.resources.EDUResourcesPlugin;
import com.ibm.lab.soln.resources.IResourceIDs;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class RecentEdits {
    private HashMap markerMap = null;
    private Vector limitList = null;
    private int limit = this.getLimit();
    private String prefix = "aRE: ";

    public RecentEdits() {
        this.limitList = new Vector();
        this.markerMap = new HashMap();
        IMarker[] markers = null;
        try {
            markers = EDUResourcesPlugin.getWorkspace().getRoot().findMarkers("com.ibm.lab.soln.resources.recentEdits", false, 2);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < markers.length) {
            if (i < this.limit) {
                this.markerMap.put(markers[i].getResource(), markers[i]);
                this.limitList.add(markers[i].getResource());
            } else {
                try {
                    markers[i].delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void addReditMarker(IResource res) throws CoreException {
        if (this.recentEditsEnabled(res) & !this.markerMap.containsKey(res) & !res.isDerived() & !res.getName().startsWith(".")) {
            if (this.markerMap.size() == this.limit) {
                IResource oldRes = (IResource)this.limitList.remove(0);
                IMarker oldMarker = (IMarker)this.markerMap.get(oldRes);
                this.markerMap.remove(oldRes);
                oldMarker.delete();
            }
            IMarker editied_marker = null;
            editied_marker = res.createMarker("com.ibm.lab.soln.resources.recentEdits");
            editied_marker.setAttribute("severity", 0);
            editied_marker.setAttribute("message", (Object)(String.valueOf(this.prefix) + res.getName() + " "));
            if (!this.getMarkerState()) {
                editied_marker.setAttribute("transient", true);
            }
            this.markerMap.put(res, editied_marker);
            this.limitList.add(res);
        }
    }

    public void checkReditMarker(IResource res, IResourceDelta delta) {
        IMarkerDelta[] markerdelta = delta.getMarkerDeltas();
        int i = 0;
        while (i < markerdelta.length) {
            if (markerdelta[i].getKind() == 2 && this.markerMap.containsValue(markerdelta[i].getMarker())) {
                this.limitList.remove(res);
                Collection col = this.markerMap.values();
                IMarker holdElement = null;
                Iterator iter = col.iterator();
                while (iter.hasNext()) {
                    IMarker element = (IMarker)iter.next();
                    if (element.getId() != markerdelta[i].getMarker().getId()) continue;
                    holdElement = element;
                }
                col.remove(holdElement);
            }
            ++i;
        }
    }

    public boolean recentEditsEnabled(IResource resource) {
        try {
            String propValue = resource.getPersistentProperty(IResourceIDs.REDIT_PROPERTY_KEY);
            return propValue == null || !propValue.equals("True");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public int getLimit() {
        int limit;
        Plugin softDialogRef = Platform.getPlugin((String)"com.ibm.lab.soln.dialogs");
        if (softDialogRef != null && (limit = softDialogRef.getPluginPreferences().getInt("Recent_Edits_Limit")) != 0) {
            return limit;
        }
        return 4;
    }

    public boolean getMarkerState() {
        boolean markerState = true;
        Plugin softDialogRef = Platform.getPlugin((String)"com.ibm.lab.soln.dialogs");
        if (softDialogRef != null) {
            markerState = softDialogRef.getPluginPreferences().getBoolean("Recent_Edits_Persistence");
        }
        return markerState;
    }
}

