/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.editor;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class ReleaseEditorCompletionProcessor
implements IContentAssistProcessor {
    protected static final String[] fgProposals = new String[]{"Abstract", "Install", "Error", "Handle", "System", "Requirements"};
    protected IContextInformationValidator fValidator = new Validator();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompletionProposal[] result = new ICompletionProposal[fgProposals.length];
        int i = 0;
        while (i < fgProposals.length) {
            ContextInformation info = new ContextInformation(fgProposals[i], "'" + fgProposals[i] + "' Release SEF popup");
            result[i] = new CompletionProposal(fgProposals[i], documentOffset, 0, fgProposals[i].length(), null, fgProposals[i], (IContextInformation)info, "Release notes keyword: '" + fgProposals[i] + "'");
            ++i;
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        IContextInformation[] result = new IContextInformation[5];
        int i = 0;
        while (i < result.length) {
            result[i] = new ContextInformation("proposal " + i + " at position " + documentOffset, "proposal " + i + " valid from " + (documentOffset - 5) + " to " + (documentOffset + 5));
            ++i;
        }
        return result;
    }

    public String getAutoTipInvocationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

