/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.interopedit.editors;

import com.ibm.lab.soln.interopedit.InteropeditPlugin;
import com.ibm.lab.soln.interopedit.editors.ActiveXWebBrowser;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ActiveXBrowserView {
    private Composite displayArea;
    private OleFrame webFrame;
    private ActiveXWebBrowser webBrowser;
    private Text webUrl;
    private OleControlSite webControlSite;
    private boolean activated = false;

    public ActiveXWebBrowser createBrowserPartControl(Composite parent) {
        this.displayArea = parent;
        FillLayout fillLayout = new FillLayout();
        this.displayArea.setLayout((Layout)fillLayout);
        this.createBrowserFrame();
        return this.createBrowserControl();
    }

    private void createBrowserFrame() {
        this.webFrame = new OleFrame(this.displayArea, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.webFrame.setLayoutData((Object)gridData);
    }

    private ActiveXWebBrowser createBrowserControl() {
        try {
            this.webControlSite = new OleControlSite((Composite)this.webFrame, 0, "Shell.Explorer");
            OleAutomation oleAutomation = new OleAutomation((OleClientSite)this.webControlSite);
            this.webBrowser = new ActiveXWebBrowser(oleAutomation, this.webControlSite);
        }
        catch (SWTException ex) {
            Label label = new Label((Composite)this.webFrame, 2048);
            InteropeditPlugin.logError("Could Not Create Browser Control", ex);
            label.setText("Could Not Create Browser Control");
            return null;
        }
        this.addReadyStateListener(this.webControlSite);
        this.activated = this.webControlSite.doVerb(-5) == 0;
        return this.webBrowser;
    }

    private void addReadyStateListener(OleControlSite webControlSite) {
        webControlSite.addPropertyListener(-525, new OleListener(){

            public void handleEvent(OleEvent event) {
                if (event.detail == 0) {
                    return;
                }
                int state = ActiveXBrowserView.this.webBrowser.getReadyState();
                switch (state) {
                    case 0: {
                        System.out.println("READYSTATE_UNINITIALIZED");
                        break;
                    }
                    case 1: {
                        System.out.println("READYSTATE_LOADING");
                        break;
                    }
                    case 2: {
                        System.out.println("READYSTATE_LOADED");
                        break;
                    }
                    case 3: {
                        System.out.println("READYSTATE_INTERACTIVE");
                        break;
                    }
                    case 4: {
                        System.out.println("READYSTATE_COMPLETE");
                    }
                }
            }
        });
    }

    public void dispose() {
        if (this.activated) {
            this.webControlSite.deactivateInPlaceClient();
            this.activated = false;
        }
        if (this.webBrowser != null) {
            this.webBrowser.dispose();
        }
        this.webBrowser = null;
    }

    public ActiveXWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public OleControlSite getWebControlSite() {
        return this.webControlSite;
    }
}

