/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.jdt.extras;

import java.util.Iterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class JavaBrowsingAction
implements IViewActionDelegate {
    IStructuredSelection ss;

    public void init(IViewPart view) {
        System.out.println("Start " + this.getClass() + ".init" + " <" + view + ">");
    }

    public void run(IAction action) {
        System.out.println("Start " + this.getClass().getName() + ".run" + " <" + action + ">");
        if (this.ss != null) {
            try {
                Iterator iter = this.ss.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (element instanceof IJavaProject) {
                        IJavaProject jp = (IJavaProject)element;
                        System.out.println("\tJava Project (" + jp.getPackageFragmentRoots().length + ") <" + jp.getElementName() + ">");
                    } else if (element instanceof IPackageFragment) {
                        IPackageFragment pf = (IPackageFragment)element;
                        if (pf.isDefaultPackage()) {
                            System.out.println("\tPackage <" + pf.getElementName() + ">");
                        } else {
                            System.out.println("\tDefault Package <" + pf.getElementName() + ">");
                        }
                    } else if (element instanceof IType) {
                        IType t = (IType)element;
                        System.out.println("\tType <" + t.getFullyQualifiedName() + ">");
                    } else if (element instanceof IMethod) {
                        IMethod m = (IMethod)element;
                        System.out.println("\tMethod (" + m.getSignature() + ") <" + m.getElementName() + ">");
                    }
                    System.out.println("\tImplementation class: " + element.getClass().getName());
                }
            }
            catch (JavaModelException e) {
                System.out.println("Exception in " + this.getClass());
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.ss = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
        System.out.println("Start " + this.getClass().getName() + ".selectionChanged" + " <" + action + ">" + " <" + selection.getClass() + ">");
    }
}

