/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.jdt.extras;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ChangeIMemberFlagAction
implements IObjectActionDelegate {
    IMember[] members = new IMember[0];
    protected boolean isChecked = false;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        int i = 0;
        while (i < this.members.length) {
            if (this.canPerformAction(action, this.members[i])) {
                this.performAction(action, this.members[i]);
            }
            ++i;
        }
    }

    protected abstract boolean performAction(IAction var1, IMember var2);

    protected abstract boolean isChecked(IAction var1, IMember var2);

    protected boolean canPerformAction(IAction action, IMember member) {
        return !member.isBinary() && !member.isReadOnly();
    }

    protected boolean replaceFlag(IMember member, int newFlag, int replacingFlag, int replacingTokenName) {
        try {
            if ((member.getFlags() & newFlag) != 0) {
                return true;
            }
            ICompilationUnit cu = member.getCompilationUnit();
            if (cu.isWorkingCopy()) {
                IBuffer buffer = cu.getBuffer();
                IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                scanner.setSource(buffer.getCharacters());
                ISourceRange sr = member.getSourceRange();
                scanner.resetTo(sr.getOffset(), sr.getOffset() + sr.getLength() - 1);
                if ((member.getFlags() & replacingFlag) != 0) {
                    int token = scanner.getNextToken();
                    while (token != 158 && token != 7 && token != replacingTokenName) {
                        token = scanner.getNextToken();
                    }
                    if (token == replacingTokenName) {
                        buffer.replace(scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition() - scanner.getCurrentTokenStartPosition() + 1, Flags.toString((int)newFlag));
                        cu.reconcile();
                        return true;
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    protected boolean deleteFlag(IMember member, int flag, int flagTokenName) {
        try {
            if ((member.getFlags() & flag) == 0) {
                return true;
            }
            ICompilationUnit cu = member.getCompilationUnit();
            if (cu.isWorkingCopy()) {
                IBuffer buffer = cu.getBuffer();
                IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                scanner.setSource(buffer.getCharacters());
                ISourceRange sr = member.getSourceRange();
                scanner.resetTo(sr.getOffset(), sr.getOffset() + sr.getLength() - 1);
                int token = scanner.getNextToken();
                while (token != 158 && token != 7 && token != flagTokenName) {
                    token = scanner.getNextToken();
                }
                if (token == flagTokenName) {
                    buffer.replace(scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition() - scanner.getCurrentTokenStartPosition() + 2, "");
                    cu.reconcile();
                    return true;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    protected boolean insertFlag(IMember member, int newFlag) {
        try {
            ICompilationUnit cu = member.getCompilationUnit();
            if (cu.isWorkingCopy()) {
                IBuffer buffer = cu.getBuffer();
                IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                scanner.setSource(buffer.getCharacters());
                ISourceRange sr = member.getSourceRange();
                scanner.resetTo(sr.getOffset(), sr.getOffset() + sr.getLength() - 1);
                scanner.getNextToken();
                buffer.replace(scanner.getCurrentTokenStartPosition(), 0, String.valueOf(Flags.toString((int)newFlag)) + " ");
                cu.reconcile();
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean canPerformAction = false;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.members = ss.toList().toArray(new IMember[ss.size()]);
            this.isChecked = true;
            int i = 0;
            while (i < this.members.length && this.isChecked) {
                this.isChecked = this.isChecked(action, this.members[i]);
                ++i;
            }
            canPerformAction = true;
            i = 0;
            while (i < this.members.length && canPerformAction) {
                canPerformAction = this.canPerformAction(action, this.members[i]);
                ++i;
            }
        } else {
            this.members = new IMember[0];
        }
        action.setChecked(this.isChecked);
        action.setEnabled(canPerformAction);
    }
}

