/* HeapTrav.java
 * Bryan Chadwick :: 2009 */
package edu.neu.ccs.demeterf.stackless;

import edu.neu.ccs.demeterf.lib.List;

import java.lang.reflect.*;
import edu.neu.ccs.demeterf.util.*;
import edu.neu.ccs.demeterf.*;

/** Traverses an Object structure using minimal Stack. */
public class HeapTrav extends edu.neu.ccs.demeterf.Traversal{
    static boolean verbose = false;
    public void setVerbose(boolean v){ verbose = v; }
    
    /** Takes a combined Builder function object */
    public HeapTrav(FC f){ super(f); }
    /** Takes a combined ID (Builder/Augmentor) function object and a Control */
    public HeapTrav(FC f, Control c){ super(f,c); }
    
    /** Do the Traversal... With an ML like Option argument (Some/None)*/
    protected <Ret> Ret traverse(Object o, Option arg){
        Continuation base = new Hole(o,arg);
        while(!base.isValue())
            base = base.step();
        return (Ret)((Value)base).val;
    }
    public class Value extends Continuation{
        final Object val;
        public Value(Object what){ super(null); val = what; }
        public boolean isValue(){ return true; }
        public Continuation apply(Object v){ throw new RuntimeException("Cannot Apply a Value to a Value"); }
        public Continuation step(){ return this; }
    }

    /** The Empty Continuation (Top-level) */
    class Hole extends Continuation{
        final Object prev;
        final Option targ;
        public Hole(Object p, Option ta){ super(null); prev = p; targ = ta; link = this; }
        public Hole(Object p, Option ta, Continuation l){ super(l); prev = p; targ = ta; }
        
        public Continuation apply(Object v){ return new Value(v); }
        public Continuation step(){
            if(control.isBuiltIn(prev.getClass()))
                return apply(dispatch(new Object[]{prev}, targ, true));
            return new ObjCont(prev,targ,List.<Object>create(),Util.getFuncFields(prev.getClass()),this);
        }
        public Object dispatch(Object[] os, Option ta, boolean prim){
            try{
                return applyBuilder(Util.addArg(os, ta), prim);
            }catch(RuntimeException e){
                if(!verbose)throw e;
                throw new RuntimeException("In HeapTrav: "+e.toString()+"\n StackTrace:\n"+this.stackTrace());
            }
        }
        public boolean isHole(){ return true; }
        public String stackTrace(){
            String ret = "    "+prev.getClass().getSimpleName();
            return ret+"\n"+(link.isHole()&&link!=this?((Hole)link).stackTrace():"");
        }
    }
    /** Midway through traversing.  Computed values are stored in 'results', and 'left' holds
     *    the Fields left to be traversed.  */
    class ObjCont extends Hole{
        final List<Object> results;
        final List<Field> left;
        public ObjCont(Object p, Option ta, List<Object> rs, List<Field> lft, Continuation l){
            super(p,ta,l); results = rs; left = lft;
        }
        
        public Continuation apply(Object v){ return new ObjCont(prev,targ,results.push(v),left.pop(),link); }
        public Continuation step(){
            if(left.isEmpty()){
                List<Object> args = results.reverse().push(prev);
                return link.apply(dispatch(args.toArray(new Object[args.length()]), targ, false));
            }
            
            Field f = left.top();
            try{
                if(!f.isAccessible())f.setAccessible(true);
                Object o = f.get(prev);
                if(control.skip(prev.getClass(),f.getName()))
                    return apply(o);
                if(o == null){
                    System.err.println("NULL FIELD: "+f.getDeclaringClass().getName()+"."+f.getName());
                }
                Class fc = o.getClass();
                Option farg = targ.some()?applyAugment(new Object[]{prev, targ.get()},f):targ;
                if(control.isBuiltIn(fc))
                    return apply(dispatch(new Object[]{o}, farg, true));
                return new ObjCont(o,farg,List.<Object>create(),Util.getFuncFields(fc),this);
            }catch(IllegalAccessException iae){ throw new RuntimeException(iae); }
        }
    }
}
