package edu.neu.ccs.demeterf.perform;
import java.lang.reflect.Method;
import java.lang.reflect.Constructor;

import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.dispatch.ConstrEntry;
import edu.neu.ccs.demeterf.dispatch.MethodEntry;
import edu.neu.ccs.demeterf.lib.List;

/** MethodDB is a List of DBEntries. Includes selection functions
 *    and a few creators. */
public class MethodDB<M>{
    public MethodDB(List<DBEntry<M>> m){ methods = m.toArray(new DBEntry[m.length()]); }
    public static MethodDB<Method> createMethodDB(Class<?> c, String name){ return Help.createMethodDB(c, name); }
    public static MethodDB<Constructor<?>> createConstrDB(Class<?> c){ return Help.createConstrDB(c); }

    protected DBEntry<M>[] methods;

    /** !Quickly! return the most specific (first) Match from the entries.
     * Returns <code>null</code> if none is found. */
    public DBEntry<M> matchEntryFast(Class<?> args[], int len){
        int max = methods.length;
        DBEntry<M> best = null;
        
        for(int i = 0; i < max; i++){
            DBEntry<M> e = methods[i];
            if(applicable(args,len,e))
                if(best == null || compare(e, best))
                    best = e;
        }
        return best;
    }
    private static <M> boolean applicable(Class<?> args[], int len, DBEntry<M> e){
        if(e.numArgs() > len)return false;
        for(int i = 0; i < e.numArgs(); i++)
            if(!e.arg(i).isAssignableFrom(args[i]))return false;
        return true;
    }
    static <M> boolean compare(DBEntry<M> e1, DBEntry<M> e2){
        int min = Math.min(e1.numArgs(), e2.numArgs());
        for(int i = 0; i < min; i++){
            if(!e1.arg(i).equals(e2.arg(i)))
                return !(e1.arg(i).isAssignableFrom(e2.arg(i)));
        }
        return (e1.numArgs() > e2.numArgs());
    }

    static class Help{
        public static List<DBEntry<Method>> getMethods(Class<?> c, String name){
            List<DBEntry<Method>> l = List.<DBEntry<Method>>create();
            while(c != null && !c.equals(Object.class)){
                for(Method m:c.getDeclaredMethods())
                    if(m.getName().equals(name)){
                        MethodEntry me = new MethodEntry(m);
                        if(l.index(me) < 0)
                            l = l.push(me);
                    }
                c = c.getSuperclass();
            }
            return l;
        }
        public static MethodDB<Method> createMethodDB(Class<?> c, String name){
            return new MethodDB<Method>(getMethods(c,name));
        }
        public static MethodDB<Constructor<?>> createConstrDB(Class<?> c){ 
            List<DBEntry<Constructor<?>>> l = List.<DBEntry<Constructor<?>>>create();
            for(Constructor<?> con:c.getDeclaredConstructors())
                l = l.push(new ConstrEntry(con));
            return new MethodDB<Constructor<?>>(l);
        }
    }
}