/* HeapTrav.java
 * Bryan Chadwick :: 2009 */
package edu.neu.ccs.demeterf.perform;

import edu.neu.ccs.demeterf.lib.List;

import java.lang.reflect.*;
import edu.neu.ccs.demeterf.util.*;
import edu.neu.ccs.demeterf.*;

/** Traverses an Object structure using minimal Stack. */
public class HeapTrav extends Traversal{
    /** Takes a combined ID (Builder/Augmentor) function object */
    public HeapTrav(FC f){ super(f); }
    /** Takes a combined ID (Builder/Augmentor) function object */
    public HeapTrav(FC f, Control c){ super(f,c); }
    
    /** Do the Traversal... With an ML like Option argument (Some/None)*/
    protected <Ret> Ret traverse(Object o, Option arg){
        Cont base = new Hole(o,arg);
        while(!base.isValue())
            base = base.step();
        return (Ret)((Value)base).val;
    }
    
    /** Traversal Continuation... */
    static abstract class Cont{
        public abstract boolean isValue();
        public abstract Cont apply(Value v);
        public abstract Cont step();
    }
    /** The Empty Continuation (Top-level) */
    class Hole extends Cont{
        final Object prev;
        final Option targ;
        final Cont link;
        public Hole(Object p, Option ta){ prev = p; targ = ta; link = this; }
        public Hole(Object p, Option ta, Cont l){ prev = p; targ = ta; link = l; }
        
        public boolean isValue(){ return false; }
        public Cont apply(Value v){ return (this == link)?v:link.apply(v); }
        public Cont step(){
            if(control.isBuiltIn(prev.getClass()))
                return apply(dispatch(new Object[]{prev}, targ, true));
            return new ObjCont(prev,targ,List.<Object>create(),Util.getFuncFields(prev.getClass()),this);
        }
        public Value dispatch(Object[] os, Option ta, boolean prim){
            return new Value(applyBuilder(Util.addArg(os, ta), prim));
        }
    }
    /** Midway through traversing.  Computed values are stored in 'results', and 'left' holds
     *    the Fields left to be traversed.  */
    class ObjCont extends Hole{
        final List<Object> results;
        final List<Field> left;
        public ObjCont(Object p, Option ta, List<Object> rs, List<Field> lft, Cont l){
            super(p,ta,l); results = rs; left = lft;
        }
        
        public Cont apply(Value v){ return new ObjCont(prev,targ,results.push(v.val),left.pop(),link); }
        public Cont step(){
            if(left.isEmpty()){
                List<Object> args = results.reverse().push(prev);
                return link.apply(dispatch(args.toArray(new Object[args.length()]), targ, false));
            }
            
            Field f = left.top();
            try{
                if(!f.isAccessible())f.setAccessible(true);
                Object o = f.get(prev);
                
                if(control.skip(prev.getClass(),f.getName()))
                    return apply(new Value(o));
                
                Option farg = targ.some()?applyAugment(new Object[]{prev, targ.get()},f):targ;
                return new Hole(o,farg,this);
            }catch(IllegalAccessException iae){ throw new RuntimeException(iae); }
        }
    }
    public class Value extends Cont{
        final Object val;
        public Value(Object what){ val = what; }
        
        public boolean isValue(){ return true; }
        public Cont apply(Value v){ throw new RuntimeException("Cannot Apply a Value to a Value"); }
        public Cont step(){ return this; }
    }
}
