/* ParTraversal.java
 * Bryan Chadwick :: 2007
 * Parallel traversal function */

package edu.neu.ccs.demeterf.parallel;

import java.lang.reflect.*;
import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.util.*;
import edu.neu.ccs.demeterf.lib.List;

/** <p>Traverses an Object structure in <b>Parallel</b>, using a Builder and
 *   Augmentor.  Java threads are used to fork each subtraversal,
 *   synchronizing on their return.  Because of the way the DemeterF traversal
 *   is written, this is rather simple.</p>
 */
public class ParTraversal2 extends Traversal{
    private boolean parallel = true;
    
    /** Create a Traversal with a Function that goes Everywhere */
    public ParTraversal2(FC f){ super(f); }
    /** Create a Traversal with a BuilderAugmentor with Selective edge/field Bypassing */
    public ParTraversal2(FC f, Control c){ super(f, c); }
    
    public <Ret> Ret traverse(Object o){
        Class<?> c = o.getClass();
        if(control.isBuiltIn(c)){
            return (Ret)applyBuilder(new Object[]{o},true);
        }else{
            List<Field> fl = Util.getFuncFields(c);
            int len = fl.length();
            Object[] ret = new Object[len+1];
            ret[0] = o;
            
            try{
                SubTravP[] subs = new SubTravP[len-1];
                
                int i = 0;
                for(Field f:fl.pop()){
                    if(!f.isAccessible())f.setAccessible(true);
                    subs[i++] = new SubTravS(f.get(o),this);
                }
                Field fst = fl.top();
                if(!fst.isAccessible())fst.setAccessible(true);
                ret[1] = traverse(fst.get(o));
                len++;
                for(i = 2; i < len; i++)
                    ret[i] = subs[i-2].waitDone();
            }catch(IllegalAccessException e){ throw new RuntimeException(e); }
            
            return (Ret)applyBuilder(ret,false);
        }
    }
    public <Ret> Ret traverseP(Object o){
        Class<?> c = o.getClass();
        if(control.isBuiltIn(c)){
            return (Ret)applyBuilder(new Object[]{o},true);
        }else{
            List<Field> fl = Util.getFuncFields(c);
            int len = fl.length();
            Object[] ret = new Object[len+1];
            ret[0] = o;
            
            try{
                SubTravS[] subs = new SubTravS[len-1];
                
                int i = 0;
                for(Field f:fl.pop()){
                    if(!f.isAccessible())f.setAccessible(true);
                    subs[i++] = new SubTravS(f.get(o),this);
                }
                Field fst = fl.top();
                if(!fst.isAccessible())fst.setAccessible(true);
                ret[1] = traverse(fst.get(o));
                len++;
                for(i = 2; i < len; i++)
                    ret[i] = subs[i-2].waitDone();
            }catch(IllegalAccessException e){ throw new RuntimeException(e); }
            
            return (Ret)applyBuilder(ret,false);
        }
    }
    public <Ret> Ret traverseS(Object o){
        Class<?> c = o.getClass();
        if(control.isBuiltIn(c)){
            return (Ret)applyBuilder(new Object[]{o},true);
        }else{
            List<Field> fl = Util.getFuncFields(c);
            int len = fl.length();
            Object[] ret = new Object[len+1];
            ret[0] = o;
            try{
                int i = 1;
                for(Field f:fl){
                    if(!f.isAccessible())f.setAccessible(true);
                    ret[i++] = traverseS(f.get(o));
                }
            }catch(IllegalAccessException e){ throw new RuntimeException(e); }
            return (Ret)applyBuilder(ret,false);
        }
    }
    
    /** Represents a traversal <i>continuation</i> (kind of), so that the return
     *   value can be stored and the parent signaled. This one applies the <code>
     *   traversal()</code> function.*/
    static class SubTravP extends Thread{
        final Object tobj;
        final ParTraversal2 trav;
        Object res;
        boolean done = false; 
        
        SubTravP(Object o, ParTraversal2 t){ tobj = o; trav = t; this.start(); }
        public void run(){
            long t = System.currentTimeMillis();
            setDone(trav.<Object>traverseP(tobj));
            System.out.println("THREAD : "+(System.currentTimeMillis()-t));
        }
        synchronized void setDone(Object r){ res = r; done = true; this.notify(); }
        synchronized Object waitDone(){
            if(!done)
                try{ this.wait(); }catch(InterruptedException e){
                    System.err.println(" ** Error Waiting on Thread!!");
                }
            return res;
        }
    }
    static class SubTravS extends SubTravP{
        SubTravS(Object o, ParTraversal2 t){ super(o,t); }
        public void run(){
            long t = System.currentTimeMillis();
            setDone(trav.<Object>traverseS(tobj));
            System.out.println("THREAD : "+(System.currentTimeMillis()-t));
        }
        synchronized void setDone(Object r){ res = r; done = true; this.notify(); }
        synchronized Object waitDone(){
            if(!done)
                try{ this.wait(); }catch(InterruptedException e){
                    System.err.println(" ** Error Waiting on Thread!!");
                }
            return res;
        }
    }
}