package edu.neu.ccs.demeterf.parallel;

public class MergeSort{
    static void p(String s){ System.out.println(s); }
    public static void main(String[] s){
        L<Integer> l = rand(10);
        p("  List: "+l);
        p(" Split: "+l.split(l.length()/2));
        p(" Front: "+l.front(l.length()/2));
        p("  Back: "+l.back(l.length()/2));
        //System.gc();Thread.yield();
        //p("  Sort: "+new Sorter<Integer>().timesort(l));
        //p(" PSort: "+new PSorter<Integer>().timesort(l));
        //p("  Sort: "+new Sorter<Integer>().timesort(l));
        //p(" PSort: "+new PSorter<Integer>().timesort(l));
    }
    
    static L<Integer> make(int ... xs){ return make(xs,xs.length-1); }
    static L<Integer> make(int[] xs, int i){ return (i < 0)?new L<Integer>():make(xs,i-1).push(xs[i]); }
    static int randInt(){ return (int)(Math.random()*20); }
    static L<Integer> rand(int k){ return (k==0?new L<Integer>():rand(k-1).push(randInt())); }
    
    static class Sorter<D extends Comparable<D>>{
        public L<D> sort(L<D> l){ return recsort(l); }
        public L<D> recsort(L<D> l){
            int len = l.length();
            if(len <= 1)return l;
            L.P<D> p = l.split(len/2);
            //p(" recsort["+Thread.currentThread().getId()+"]: "+l);
            return merge(recsort(p.lt), recsort(p.rt));
        }
        
        class T{
            long mil;
            L<D> lst;
            T(long m, L<D> l){ mil = m; lst = l; }
            public String toString(){ return " MSec: "+mil; }//+" : "+lst; }
        }
        
        public T timesort(L<D> l){
            System.gc();Thread.yield();
            long tm = System.currentTimeMillis();
            L<D> r = sort(sort(l));
            return new T(System.currentTimeMillis()-tm, r);
        }
    }
    
    static class PSorter<D extends Comparable<D>> extends Sorter<D>{
        public L<D> sort(L<D> l){
            int len = l.length();
            if(len <= 1)return l;
            L.P<D> p = l.split(len/2);
            Thrd lt = new Thrd(p.lt); lt.start();
            L<D> rt = recsort(p.rt);
            p = null;
            lt.waitFor();
            return merge(lt.res, rt);
        }
        
        class Thrd extends Thread{
            L<D> lst, res;
            boolean fin = false;
            Thrd(L<D> l){ lst = l; res = null; }
            public void run(){ res = recsort(lst); done(); }
            synchronized void done(){ fin = true; this.notifyAll(); }
            synchronized void waitFor(){ try{ while(!fin)wait(); }catch(InterruptedException e){} }
        }
    }
    
    static <D extends Comparable<D>> L<D> merge(L<D> l1, L<D> l2){
        if(l1.isEmpty())return l2;
        if(l2.isEmpty())return l1;
        if(l1.first().compareTo(l2.first()) <= 0)
            return merge(l1.rest(), l2).push(l1.first());
        return merge(l1, l2.rest()).push(l2.first());
    }
    
    
    static class L<D extends Comparable<D>>{
        static class P<D extends Comparable<D>>{
            L<D> lt, rt;
            P(L<D> l, L<D> r){ lt = l; rt = r;}
            public String toString(){ return "<"+lt+" :: "+rt+">"; }
        }
        boolean isEmpty(){ return true; }
        D first(){ throw new RuntimeException("L.first() Bad"); }
        L<D> rest(){ throw new RuntimeException("L.rest() Bad"); }
        int length(){ return 0; }
        L<D> reverse(){ return reverse(new L<D>()); }
        L<D> reverse(L<D> ac){ return ac; }
        L<D> push(D d){ return new C<D>(d, this); }
        L<D> append(L<D> l){ return l; }
        P<D> split(int k){ return split(k,new L<D>()); }
        P<D> split(int k, L<D> ac){ throw new RuntimeException("L.split() Bad"); }
        L<D> front(int i){ throw new RuntimeException("L.split() Bad"); }
        L<D> back(int i){ throw new RuntimeException("L.split() Bad"); }
        public String toString(){ return ""; }
    }
    static class C<D extends Comparable<D>> extends L<D>{
        D f;
        L<D> r;
        C(D ff, L<D> rr){ f = ff; r = rr; }
        boolean isEmpty(){ return false; }
        D first(){ return f; }
        L<D> rest(){ return r; }
        int length(){ return 1+r.length(); }
        L<D> reverse(L<D> ac){ return r.reverse(ac.push(f)); }
        L<D> append(L<D> l){ return r.append(l).push(f); }
        P<D> split(int k, L<D> ac){ 
            return k==0?new P<D>(ac.reverse(),this):r.split(k-1, ac.push(f));    
        }
        L<D> front(int i){ return (i==0?new L<D>():r.front(i-1).push(f)); }
        L<D> back(int i){ return (i==0?this:r.back(i-1)); }
        public String toString(){ return f+" "+r; } 
    }
}
