/**
 * DemeterF Main package: transformation/traversals with optional arguments.
 *
 * <p> Traversals are parametrized by a function objects.
 * Each function class (<tt>FC</tt>) implements <tt>combine</tt> and/or
 * <tt>update</tt> methods, which are called by a traversal when walking a
 * structure.</p>
 *
 * <p><i>Note</i>: <tt>update</tt> methods are only called when the <tt>Traversal</tt>
 * <tt>traverse(Object o, Object a)</tt> method is called; i.e., when the
 * original traversal is passed a starting context. See
 * {@link edu.neu.ccs.demeterf.examples Examples} for, well... some examples.</p>
 *
 * <ul>
 * <li><font size=5><tt>combine</tt></font> methods have the form:
 *    <blockquote>
 *    <code>Ret combine(Target t, ..., Arg a)</code>
 *    </blockquote>
 *    for datatypes to be
 *    reconstructed, <i>after</i> the traversal of any subobjects.</p>
 *
 *    <p><code>Ret</code> is (of course) the return type, <code>Target</code>
 *    should be replaced by the type (or a supertype) at which the method will be 
 *    called, and <code>Arg</code> should be the expected traversal context type.
 *    The [<code>...</code>] should be a list of types and bindings
 *    (i.e., formal method parameters) that are expected from sub-traversals of
 *    the (<tt>Target</tt>) datatype's fields; no fields? no extra parameters
 *    needed.</p>
 *    
 *    <p>All parameters are optional, but <b>order</b> matters: e.g., if a method
 *    accepts less than the number of actual parameters available, then it may still
 *    be called if the types <i>match</i>. See {@link edu.neu.ccs.demeterf.dispatch Dispatch}
 *    for method matching/dispatch description.</p></li><br/>
 *
 * <li><font size=5><tt>update</tt></font>: methods have the form:
 *    <blockquote> 
 *    <code>Ret update(Target t, Target.field f, Arg a)</code>
 *    </blockquote>
 *    for datatypes where the traversal argument needs to be modified for
 *    subtraversals. <code>Ret</code> should be the new argument type (it can be
 *    different), <code>Target</code> is where this method should be called (on the
 *    way down), <code>Arg</code> is the type of the previous traversal argument, and
 *    <code>Target.field</code> is an encoding of which field of <code>Target</code>
 *    we are about to traverse.</p>
 *    <p>We encode the field to be traversed by using an inner <code>public static
 *    class</code> that shares the <i>name</i> of the field.  There must be a
 *    <code>public</code> path (the outer classes must be public, all the way up) in
 *    order for the encoding to work. The <code>DemeterF</code> class generator does
 *    this automatically... see examples package for some hand-coded examples.</p>
 *
 *    <p>The <code>Arg</code> and <code>Ret</code> types should generally be the
 *    same type (or share a common supertype), but anything is possible.<br/> &nbsp;
 *    &nbsp;&nbsp;e.g., implementing:
 *    <blockquote>
 *        <code>Object update(Object o){ return o; }</code>
 *    </blockquote>
 *    will give each <code>combine</code> method access to its parent as a traversal
 *     context.</p>
 *    </li><br> </ul>
 *
 * Return types of these methods can be as specific or general as you like.  Argument
 * types are used for method execution selection, so they should match expected
 * subtraversal return values.  For development safety, during traversal a
 * <tt>BuilderException</tt> is thrown if no <tt>combine</tt> method
 * with an applicable signature is found.
 * 
 * See the individual packages/classes for more info.
 */

package edu.neu.ccs.demeterf;