/** 
 * <p>
 * DemFGen useful library classes. These classes can be imported and used with
 * <tt>DemFGen</tt> as collection classes.  The file "lib.cd" contains the
 * <tt>DemFGen</tt> CD file that represents the structure of these classes. It
 * can be included in projects to allow parsing/printing of these classes for
 * use in your own CD files.</p>
 * 
 * <p>Here's the library structures from <tt><b>lib.cd</b></tt>:
 * <blockquote><pre>
 *    package edu.neu.ccs.demeterf.demfgen.lib;
 *
 *    import edu.neu.ccs.demeterf.demfgen.lib.*;
 *
 *    nogen List(X) = Cons(X) | Empty(X).
 *    nogen Cons(X) = <first> X <rest> List(X).
 *    nogen Empty(X) = .
 * 
 *    nogen Option(X)= Some(X) | None(X).
 *    nogen Some(X)  = <just> X.
 *    nogen None(X)  = .
 * 
 *    nogen RBColor = RED | BLACK.
 *    nogen RED = "red".
 *    nogen BLACK = "black".
 *  
 *    nogen RBTree(X:Comparable) = RBNode(X) | RBLeaf(X).
 *    nogen RBNode(X:Comparable) = "(node" <color> RBColor <data>  X
 *                                         <left>  RBTree(X)
 *                                         <right> RBTree(X) ")".
 *    nogen RBLeaf(X:Comparable) = .
 * </pre></blockquote>
 * </p>
 * 
 * <p>
 * Each class also contains tons of useful methods that will help make your
 * life easier... and it's all done functionally :)</p>
 */

package edu.neu.ccs.demeterf.lib;