package edu.neu.ccs.demeterf.lib;

import java.util.Comparator;

import edu.neu.ccs.demeterf.Fields;

/** Wrapping class for Sets, so that the elements are not
 *    forced to be <tt>Comparable</tt>. */
public class Wrap<X> implements Comparable<Wrap<X>>{
    protected final X x;
    private final Comparator<X> comp;
    
    /** Field class for Wrap.x */
    public static class x extends Fields.any{}
    
    
    /** Getter for Wrap.x */
    public X getX(){ return x; }
    
    /** Simple Comparator for comparable elements */
    static class CComp<X> implements Comparator<X>{
        public int compare(X a, X b){ return ((Comparable<X>)a).compareTo(b); }
    }
    /** Simple Comparator for Sorting Wraps */
    static class LComp<X> extends List.Comp<Wrap<X>>{
        public boolean comp(Wrap<X> a, Wrap<X> b){ return a.compareTo(b) <= 0; }
    }
    
    /** Create a Wrap from a comparable element */
    public Wrap(X xx){ this(xx, new CComp<X>()); }
    /** Create a Wrap from an element with a comparator */
    public Wrap(X xx, Comparator<X> c){ x = xx; comp = c; }
    /** Implement the Comparable Interface */
    public int compareTo(Wrap<X> w){ return comp.compare(x,w.x); }
    /** Canonical "equals" */
    public boolean equals(Object o){
        if(!(o instanceof Wrap))return false;
        return x.equals(((Wrap<X>)o).x);
    }
    /** Canonical ToString */
    public String toString(){ return x.toString(); }
    /** Canonical HashCode */
    public int hashCode(){ return x.hashCode(); }
}