package edu.neu.ccs.demeterf.lib;

import java.util.Comparator;

import edu.neu.ccs.demeterf.Fields;

/** Represents a Set of comparable Elements, implemented with RBTrees. */
public class Set<X> implements java.lang.Iterable<X>{
    protected final RBTree<Wrap<X>> tree;
    private final Comparator<X> comp;
    
    /** Field Class */
    public static class tree extends Fields.any{}
    
    /** Function Class to help in the merging of Sets.  Merges same elements calling merge(...). */
    public static abstract class Merge<X>{ public abstract X merge(X a, X b); }
    
    /** Construct the <i>empty</i> Set of Comparable elements. */
    private Set(){ this(new Wrap.CComp<X>(),RBTree.<Wrap<X>>create()); }
    /** Construct the <i>empty</i> Set with a separate Comparator. */
    private Set(Comparator<X> c){ this(c,RBTree.<Wrap<X>>create()); }
    
    static class Wrapper<X> extends List.Map<X,Wrap<X>>{
        Comparator<X> c;
        Wrapper(Comparator<X> cc){ c = cc; }
        public Wrap<X> map(X x){ return new Wrap<X>(x,c); }
    }
    /** Construct a Set from a List with a separate Comparator.  Duplicates will be ignored. */
    private Set(List<X> l, final Comparator<X> c){
        this(c,RBTree.create(l.map(new Wrapper<X>(c))));
    }
    
    /** Construct a Set from a List of <tt>Comparable</tt> elements.  Duplicates
     *    will be ignored. Left Public to support Parsing */
    public Set(List<X> l){ this(l,new Wrap.CComp<X>()); }
    /** Construct a Set from a tree of Wrapped (Comparable) elements. */
    public Set(RBTree<Wrap<X>> t){ this(new Wrap.CComp<X>(),t); }
    
    /** Construct the <i>empty</i> Set of Comparable elements. */
    public static <X extends Comparable<X>> Set<X> create(){ return new Set<X>(); }
    /** Construct the <i>empty</i> Set with a separate Comparator. */
    public static <X> Set<X> create(Comparator<X> c){ return new Set<X>(c,RBTree.<Wrap<X>>create()); }
    /** Construct a Set from a List of <tt>Comparable</tt> elements.  Duplicates will be ignored. */
    public static <X extends Comparable<X>> Set<X> create(List<X> l){ return new Set<X>(l); }
    /** Construct a Set from a List with a separate Comparator.  Duplicates will be ignored. */
    public static <X> Set<X> create(List<X> l, Comparator<X> c){ return new Set<X>(l,c); }
    /** Construct a Set from a number of <tt>Comparable</tt> elements.  Duplicates will be ignored. */
    public static <X extends Comparable<X>> Set<X> create(X ... xs){ return new Set<X>(List.create(xs)); }
    
    
    // Private Creators... reverse the order since the list/tree will be Wrapped elements
    private Set(Comparator<X> c, List<Wrap<X>> l){ this(c,RBTree.<Wrap<X>>create(l)); }
    private Set(Comparator<X> c, RBTree<Wrap<X>> t){ tree = t; comp = c; }
    private Set<X> make(RBTree<Wrap<X>> t){ return new Set<X>(comp,t); }
    private Set<X> make(List<Wrap<X>> lst){ return new Set<X>(comp,lst); }
    private List<Wrap<X>> toWrapList(){ return tree.toList(); }
    
    /** Is the given element present in this Set? */
    public boolean contains(X x){ return tree.contains(new Wrap<X>(x,comp)); }
    /** Is this set <i>empty</i>? */
    public boolean isEmpty(){ return tree.isLeaf(); }
    /** Return the nuber of elements in this Set */
    public int size(){ return tree.size(); }
    /** Returns a new Set that also contains the given element. */
    public Set<X> add(X x){ return make(tree.insert(new Wrap<X>(x,comp))); }
    /** Returns a new Set that no longer contains the given element. */
    public Set<X> remove(X x){ return make(tree.remove(new Wrap<X>(x,comp))); }
    /** Is this Set a <i>subset</i> of (or equal to) the given set? */
    public boolean subseteq(Set<X> s){ return s.tree.containsAll(this.tree); }
    /** Returns a new Set that is the <i>union</i> of <b>this</b> and the given Set. */
    public Set<X> union(Set<X> s){ return make(tree.insertAll(s.tree)); }
    
    static class InTree<X> extends List.Pred<Wrap<X>>{
        RBTree<Wrap<X>> t;
        InTree(RBTree<Wrap<X>> tt){ t = tt; }
        public boolean huh(Wrap<X> x){ return t.contains(x); }
    }
    /** Returns a new Set that is the <i>intersection</i> of <b>this</b> and the given Set. */
    public Set<X> intersect(final Set<X> s){
        return make(toWrapList().filter(new InTree<X>(s.tree)));
    }
    /** Returns a new Set that is the <i>difference</i> of <b>this</b> and the given Set. */
    public Set<X> difference(final Set<X> s){
        return make(toWrapList().filterout(new InTree<X>(s.tree)));
    }
    
    static class UnWrapper<X> extends List.Map<Wrap<X>,X>{
        public X map(Wrap<X> w){ return w.x; }
    }
    /** Returns this Set as a List, in the order defined by the Comparator. */
    public List<X> toList(){ return toWrapList().map(new UnWrapper<X>()); }
    
    /** Returns an iterator for this Set, in the order defined by the Comparator. */
    public java.util.Iterator<X> iterator(){ return toList().iterator(); }
    
    class Merger extends List.Fold<Wrap<X>, RBTree<Wrap<X>>>{
        Merge<X> m;
        Merger(Merge<X> mm){ m = mm; }
        public RBTree<Wrap<X>> fold(Wrap<X> w, RBTree<Wrap<X>> t){
            if(!t.contains(w))return t.insert(w);
            return t.replace(new Wrap<X>(m.merge(w.x,t.find(w).x),comp));
        }
    }
    /** Merge two sets with like elements merged by the given function object */
    public Set<X> merge(Set<X> s, final Merge<X> m){
        return make(s.toWrapList().fold(new Merger(m), tree));
    }
    /** Merge a single element merged by the given function object */
    public Set<X> merge(X x, final Merge<X> m){
        Wrap<X> w = new Wrap<X>(x,comp);
        if(!tree.contains(w))return make(tree.insert(w));
        return make(tree.replace(new Wrap<X>(m.merge(x,tree.find(w).x),comp)));
    }
    
    /** Set equality (s == t) is (s.subset(t) && t.subset(s)). */
    public boolean equals(Object o){
        if(!(o instanceof Set))return false;
        Set<X> s = (Set<X>)o;
        return (s.size() == this.size() && tree.containsAll(s.tree));
    }
    /** Produce a string representation of this Set. */
    public String toString(){ return "{ "+toList().toString(" ","")+" }"; }
    
    /** Return the combined underlying elements HashCode */
    public int hashCode(){ return tree.hashCode(); }
}
