package edu.neu.ccs.demeterf.lib;

import java.util.Comparator;

/** Represents the Leaf of an RBTree, e.g., the empty tree */
public class RBLeaf<X extends Comparable<X>> extends RBTree<X>{
    public RBLeaf(){}
    public String toString(){ return ""; }
    public boolean equals(Object o){ return (o instanceof RBLeaf); }
    
    public boolean isLeaf(){ return true; }
    public boolean isBlack(){ return true; }
    public boolean isRed(){ return false; }
    public boolean contains(X x, Comparator<X> comp){ return false; }
    public boolean containsAll(RBTree<X> x, Comparator<X> comp){ return x.isLeaf(); }
    public X find(X x, Comparator<X> comp){  throw new RuntimeException("RBLeaf.find() : No Elements!"); }
    public List<X> toList(){ return new Empty<X>(); }
    
    public RBNode<X> asNode(){ throw new RuntimeException("RBLeaf.asNode(): Not a Node!"); }
    RBTree<X> makeBlack(){ return this; }
    RBTree<X> makeRed(){  throw new RuntimeException("RBLeaf.makeRed() : Cannot be Red!"); }
    public X pred(){ throw new RuntimeException("RBLeaf.pred(): No Predicessor!"); }
    public X succ(){ throw new RuntimeException("RBLeaf.succ(): No successor!"); }
    public X min(){ throw new RuntimeException("RBLeaf.succ(): No Minimum!"); }
    public X max(){ throw new RuntimeException("RBLeaf.succ(): No Maximium!"); }
    
    public RBTree<X> remove(X x){ return this; }
    public RBTree<X> remove(X x, Comparator<X> c){ return this; }
    public RBTree<X> replace(X x, Comparator<X> comp){ return node(red(), x, this, this); }
    public int size(){ return 0; }
    
    RBTree<X> del(X x, Comparator<X> c){ return this; }
    RBTree<X> ins(X x, Comparator<X> comp){ return node(red(), x, this, this); }
    
    public int hashCode(){ return 1321; }
}

