package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;

import java.util.Comparator;

/** Represents a Map of comparable Keys to any old Values, implemented with RBTrees.
 *    The Key requires a Comparator<Key>, but if Key is Comparable, you can simply
 *    supply the type to the createor functions. Also see <tt>Map.Entry</tt>. */
public class Map<Key, Val> implements Iterable<Entry<Key,Val>>{
    protected final RBTree<Entry<Key,Val>> tree;
    private final Comparator<Key> comp;
    
    /** Field Class */
    public static class tree extends Fields.any{}
    
    /** Function Class to help in the merging of Maps.  Merges Values associated to
     *    the same Key when calling merge(...). */
    public static abstract class Merge<Val>{ public abstract Val merge(Val a, Val b); }
    
    /** Trnasformer for Values o fa given Map */
    public static abstract class Transform<X,Y>{ public abstract Y transform(X x); }
    
    class Transformer<NV> extends List.Map<Entry<Key,Val>, Entry<Key,NV>>{
        List.Map<Val,NV> tr;
        Transformer(List.Map<Val,NV> trr){ tr = trr; }
        public Entry<Key,NV> map(Entry<Key,Val> e){
            return Entry.<Key,NV>create(e.key, tr.map(e.val), comp);
        }
    }
    /** Transform Each of the Keys */
    public <NVal> Map<Key,NVal> transformValues(final List.Map<Val,NVal> tr){
        return Map.<Key,NVal>create(toList().map(new Transformer<NVal>(tr)),comp);
    }
    
    /** Create an Empty Map of *Comparable* Elements. */
    private Map(){ this(RBTree.<Entry<Key,Val>>create(), new Entry.CComp<Key>()); }
    /** Create an Empty Map using the given Comparator to compare elements. */
    private Map(Comparator<Key> c){ this(RBTree.<Entry<Key,Val>>create(), c); }
    /** Create a Map from the given list of Entries using the given Comparator. */    
    private Map(List<Entry<Key,Val>> l, Comparator<Key> c){ this(RBTree.<Entry<Key,Val>>create(l),c); }
    
    /** Create a Map from the given list of Entries. The <tt>Key</tt> <b>must</b> implement
     *    <tt>Comparable&lt;Key&gt;</tt>*/
    public Map(List<Entry<Key,Val>> l){ this(l,new Entry.CComp<Key>()); }
    /** Create a Map from the given RBTree of Entries. */
    public Map(RBTree<Entry<Key,Val>> t){ this(t, new Entry.CComp<Key>()); }
    
    /** Create an Empty Map of *Comparable* Elements. */
    public static <Key extends Comparable<Key>,Val> Map<Key,Val> create(){ return new Map<Key,Val>(); }
    /** Create an Empty Map using the given Comparator to compare elements. */
    public static <Key,Val> Map<Key,Val> create(Comparator<Key> c){
        return new Map<Key,Val>(c);    
    }
    /** Create a Map from the given list of Entries, with Comparable Keys. */    
    public static <Key extends Comparable<Key>,Val> Map<Key,Val> create(List<Entry<Key,Val>> l){
        return new Map<Key,Val>(RBTree.<Entry<Key,Val>>create(l),new Entry.CComp<Key>());
    }
    /** Create a Map from the given list of Entries, with the given Comparator. */    
    public static <Key,Val> Map<Key,Val> create(List<Entry<Key,Val>> l, Comparator<Key> c){
        return new Map<Key,Val>(RBTree.<Entry<Key,Val>>create(l),c);
    }
    /** Create a Map from the given list of Entries using the given Comparator. */    
    public static <Key extends Comparable<Key>,Val> Map<Key,Val> create(List<Key> ks, List<Val> vs){
        return create(ks,vs, new Entry.CComp<Key>());
    }
    
    static class Zipper<K,V> extends List.Zip<K, V, Entry<K,V>>{
        Comparator<K> c;
        Zipper(Comparator<K> cc){ c = cc; }
        public Entry<K,V> zip(K k, V v){ return Entry.create(k, v, c); }
    }
    /** Create a Map from the given list of Entries using the given Comparator. */    
    public static <Key,Val> Map<Key,Val> create(List<Key> ks, List<Val> vs, final Comparator<Key> c){
        return create(ks.zip(new Zipper<Key,Val>(c), vs), c);
    }
    
    static class HashComp<Key> implements Comparator<Key>{
        public int compare(Key k1, Key k2){
            return k1.hashCode()-k2.hashCode();
        }
    }
    /** Create a Map that uses Hashcode to compare Keys. */
    public static <Key,Val> Map<Key,Val> hashMap(){
        return new Map<Key,Val>(new HashComp<Key>());
    }
    /** Create a Map from the given Entry List that uses Hashcode to compare Keys. */
    public static <Key,Val> Map<Key,Val> hashMap(List<Entry<Key,Val>> l){
        return new Map<Key,Val>(l, new HashComp<Key>());
    }
    /** Create a Map from the given Key and Value Lists that uses Hashcode to compare Keys. */
    public static <Key,Val> Map<Key,Val> hashMap(List<Key> ks, List<Val> vs){
        return create(ks,vs, new HashComp<Key>());
    }
    /** Create a Map from the given Java HashMap. */
    public static <Key,Val> Map<Key,Val> hashMap(java.util.Map<Key, Val> hash){
        Map<Key,Val> m = Map.<Key,Val>hashMap();
        for(java.util.Map.Entry<Key, Val> ent : hash.entrySet())
            m = m.put(ent.getKey(), ent.getValue());
        return m;
    }
    
    
    /** Create a Map from the given RBTree of Entries using the given Comparator. */
    private Map(RBTree<Entry<Key,Val>> t, Comparator<Key> c){ tree = t; comp = c; }
    private Map<Key,Val> make(RBTree<Entry<Key,Val>> t){ return new Map<Key,Val>(t,comp); }
    
    /** Return the number of elements in this Map */
    public int size(){ return tree.size(); }
    /** Does this Map contain the given Key? */
    public boolean containsKey(Key k){ return tree.contains(Entry.create(k,(Val)null,comp)); }
    /** Is this Map Empty? */
    public boolean isEmpty(){ return tree.isLeaf(); }
    /** Return a new Map with the given Mapping (Entry) added. */
    public Map<Key,Val> put(Key k, Val v){ return make(tree.insert(Entry.create(k,v,comp))); }
    /** Return a new Map with the given Mapping added or updated if it exists. */
    public Map<Key,Val> remap(Key k, Val v){
        Entry<Key,Val> e = Entry.create(k,v,comp);
        return make(!containsKey(k)?tree.insert(e):tree.replace(e));
    }
    /** Get the Value that the given Key is mapped to. */
    public Val get(Key k){ return tree.find(Entry.create(k,(Val)null,comp)).val; }
    /** Return a new Map that does not include the given key */
    public Map<Key,Val> remove(Key k){ return make(tree.remove(Entry.create(k,(Val)null,comp))); }
    
    /** Merge the given Map into this one, ignoring duplicate mappings. */
    public Map<Key,Val> merge(Map<Key,Val> s){ return make(tree.insertAll(s.tree)); }
    
    class Merger extends List.Fold<Entry<Key,Val>, RBTree<Entry<Key,Val>>>{
        Merge<Val> m;
        Merger(Merge<Val> mm){ m = mm; }
        public RBTree<Entry<Key,Val>> fold(Entry<Key,Val> e, RBTree<Entry<Key,Val>> t){
            if(!t.contains(e))return t.insert(e);
            return t.replace(Entry.create(e.key,m.merge(e.val,t.find(e).val),comp));
        }
    }
    /** Merge the given Map into this one, using the given Merge function object
     *    to merge the elements of matching Keys */
    public Map<Key,Val> merge(Map<Key,Val> s, final Merge<Val> m){
        return make(s.toList().fold(new Merger(m), tree));
    }
    /** Merge the given Map into this one, using the given Merge function object
     *    to merge the elements of matching Keys */
    public Map<Key,Val> merge(Key k, Val v, final Merge<Val> m){
        Entry<Key,Val> e = Entry.create(k,v,comp); 
        if(!tree.contains(e))return make(tree.insert(e));
        return make(tree.replace(Entry.create(e.key,m.merge(v,tree.find(e).val),comp)));
    }
    
    class Keyer extends List.Map<Entry<Key,Val>,Key>{
        public Key map(Entry<Key,Val> e){ return e.getKey(); }
    }
    /** Reutrn a List of the Keys contained in this Map. */
    public List<Key> keys(){ return toList().map(new Keyer()); }
    
    class Valer extends List.Map<Entry<Key,Val>,Val>{
        public Val map(Entry<Key,Val> e){ return e.getVal(); }
    }
    /** Reutrn a List of the Values contained in this Map. */
    public List<Val> values(){ return toList().map(new Valer()); }
    /** Return all the Entries in this Map as a list, in Key order. */
    public List<Entry<Key,Val>> toList(){ return tree.toList(); }
    /** Return an Iterator over the Entries in this Map, in Key order. */
    public java.util.Iterator<Entry<Key,Val>> iterator(){ return toList().iterator(); }
    /** Produce a String representation of this Map. */
    public String toString(){ return "[ "+toList().toString(" ","")+" ]"; }
    /** Produce a String representation of this Map. */
    public String toTreeString(){ return "[ "+tree+" ]"; }
    
    /** Convert this Map into a java.util.Map */
    public java.util.Map<Key, Val> toJavaMap(){
        java.util.Map<Key,Val> m = new java.util.HashMap<Key,Val>();
        for(Entry<Key,Val> e:this)m.put(e.getKey(), e.getVal());
        return m;
    }
    
    /** Retur this Maps HashCode */
    public int hashCode(){ return 3*tree.hashCode(); }
    
    /** Is this Map the same as the given Object? */
    public boolean equals(Object o){
        if(!(o instanceof Map))return false;
        Map oo = (Map)o;
        return (tree.size() == oo.size() &&
                tree.toList().equals(oo.tree.toList()));
    }
}
