package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;

/** Represents a Lisp style cons list.  You should not use the constructor, use List.push(...)
 *    to add an element to the front of the list.  It is left public so that the parser
 *    generator can parse different lists if needed. */
public class Cons<X> extends List<X>{
    protected final X first;
    protected final List<X> rest;
    //private final int hash;
    public Cons(X f, List<X> r){
        super(r.length()+1);
        first = f;
        rest = r;
        //hash = first.hashCode()+3*rest.hashCode();
    }
    
    public X top(){ return first; }
    public List<X> pop(){ return rest; }
    public boolean isEmpty(){ return false; }
    
    public static class first extends Fields.any{}
    public static class rest extends Fields.any{}
    
    public boolean equals(Object o){
        if(! (o instanceof Cons))return false;
        List<?> c = (List<?>)o;
        if(c.length() != length())return false;
        for(X x:this){
            if(!x.equals(c.top()))return false;
            c = c.pop();
        }
        return true;
    }
    
    public int hashCode(){
        //return hash;
        return first.hashCode()+3*rest.hashCode();  
    }
    
    /** Getter for Entry.key */
    public X getFirst(){ return first; }
    /** Getter for Entry.val */
    public List<X> getRest(){ return rest; }
    
}
