/* Traversal.java
 * Bryan Chadwick :: 2007
 * Traversal With Arguments and Augmentors */

package edu.neu.ccs.demeterf.lazy;

import java.lang.reflect.*;
import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.util.*;

/** Special Traversal that only traverses fields as needed based on the signatures
 * of the combine methods given. This does not currently work with type-preserving functions
 * , <code>TP</code>. */
public class Traversal extends edu.neu.ccs.demeterf.Traversal{
    
    /** Create a parameterized Traversal that goes Everywhere */
    public Traversal(FC f){ super(f); }
    
    /** Do the Traversal... No argument */
    public <Ret> Ret traverse(Object o){ return this.<Ret>traverse(o, Option.none()); }
    
    /** Do the Traversal... With argument */
    public <Ret> Ret traverse(Object o, Object a){ return this.<Ret>traverse(o, Option.some(a)); }
    
    /** Do the Traversal... With an ML like Argument (Some/None) */
    protected <Ret> Ret traverse(Object o, Option arg){
        Class<?> c = o.getClass();
        List<Field> fl = Util.getFuncFields(c);
        Object ret[] = new Object[fl.length()+1];
        ret[0] = o;
        
        Option narg = arg;
        if(arg.some())narg = Option.some(applyAugment(new Object[]{o, arg.get()},null));
        
        for(int i = 0; i < fl.length(); i++){
            try{
                Field f = fl.lookup(i);
                f.setAccessible(true);
                ret[i+1] = Thunk.create(f.get(o), this);
            }catch(Exception e){ throw (RuntimeException)e; }
        }
        Object bRet = applyBuilder(ret, arg);
        return (Ret)bRet;
    }

    /** Apply the Builder to this list of 'Fields'.  Includes the extra
     * "traversal-control-through-method-signature" logic */    
    private Object applyBuilder(Object o[], Option arg){
        Object save[] = o = Util.addArg(o, arg);
        DBEntry<Method> me = null;
        for(int k = 0; me == null && k <= o.length+1; k++){
            Class<?> cs[] = Util.classesFromObjects(o, o.length);
            me = buildDB.matchEntryFast(cs);
            
            if(me == null){
                if(k < o.length-1)
                    o[k+1] = (arg.some())?((Thunk)o[k+1]).go(arg.get()):((Thunk)o[k+1]).go();
                else{
                    throw new RuntimeException("\n   DemeterF: Did Not Find Match for:\n      "+
                            Util.signature(func.getClass(), FC.buildMethodName, o, o.length));
                }
            }
        }
        Object ret = o[0];
        try{
            Method m = me.getMethod();
            m.setAccessible(true);
            ret = m.invoke(func, Util.objectSubset(o, m.getParameterTypes().length));
        }catch(java.lang.reflect.InvocationTargetException ite){
            throw (RuntimeException)ite.getCause();
        }catch(Exception e){
            e.printStackTrace();
        }
        return ret;
    }
 }
