package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.inline.classes.*;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Option;
import edu.neu.ccs.demeterf.dispatch.Type;
import edu.neu.ccs.demeterf.demfgen.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.ClassHier.InhrtPair;
import edu.neu.ccs.demeterf.util.CLI;

public class Inline{
    static boolean FOR_ALL = false;
    static boolean RESIDUE = true;
    
    public static final String PATH = "--path", BUILTINS = "--builtins", BYPASS = "--bypass",
        IGNORE = "--ignore", VERBOSE = "--verbose", TARG = "--targ", HEAP = "--heap",
        PARALLEL = "--parallel", JAVAHACK = "--javahack", FORALL = "--forall",
        JUSTTYPE = "--justtype", STRICT = "--strict", CONCRETES = "--concretes",
        PARFIELDS = "--parfields", PARTYPES = "--partypes", PUBFIELDS = Diff.pubfields;
    public static final List<String> allOpts = List.create(PATH, BUILTINS, BYPASS,
            IGNORE, VERBOSE, TARG, HEAP,PARALLEL, JAVAHACK, FORALL, JUSTTYPE,
            STRICT, CONCRETES, PUBFIELDS, PARFIELDS, PARTYPES);
        
    static void p(String s){ System.err.print(s); }

    public static void main(String args[]) throws Exception {
        List<String>[] all = CLI.splitArgs(args);
        List<String> opts = all[CLI.OPTS];
        String nonOpt[] = all[CLI.ARGS].toArray(new String[all[CLI.ARGS].length()]);
        List<String> unknown = CLI.invalidOptions(opts, allOpts);
        if(!unknown.isEmpty())
            usage("Unknown Option(s): "+unknown.toString(", ",""));

        if(nonOpt.length != 3)usage("Not Enough Aguments");
        String
            cdFile = nonOpt[0],
            funClass = nonOpt[1],
            stClass = nonOpt[2];

        for(String p : CLI.separateOption(PATH,opts))Type.addPath(p);
        
        
        try{
            List<CDFile> CDs = DemFGenMain.resolveCDFile(cdFile);
            SubTyping subs = new SubTyping(CDs);
            List<InhrtPair> inhrt = DemFGenMain.subtypes(CDs);
            List<TypeDef> types = DemFGenMain.removeSyntax(DemFGenMain.flatten(CDs, inhrt));

            System.out.println(doGen("", new NoImpl(), CDs, "", funClass, stClass, types, subs, opts));
            
            System.exit(0);
        }catch(RTParseException pe){ error(pe,"Parse");
        }catch(java.io.FileNotFoundException fe){ error(fe,"File");
        }catch(RTFileNotFound fe){ error(fe,"File");
        }catch(TypeError te){ error(te,"Type");
        }catch(RuntimeException e){ error(e,"", true); }
        System.exit(1);
    }
    
    public static String doGen(String name, Impl impl, List<CDFile> CDs, String pack, String funClass, String stClass,
            List<TypeDef> types, SubTyping subs, List<String> opts){

        Diff.storeOptions(opts);
        
        GenControl ctrl = GenControl.make(subs,
                List.create(CLI.separateOption(BUILTINS,opts)),
                List.create(CLI.separateOption(BYPASS,opts)),
                List.create(CLI.separateOption(IGNORE,opts)));
        String[] targC = CLI.separateOption(TARG,opts);
        Option<TypeUse> targ = (targC.length > 0) ?
                Option.<TypeUse>some(TypeUse.makeType(targC[0])):Option.<TypeUse>none();
        Help.verbose = CLI.optionSet(VERBOSE,opts);
        SubTyping.JAVA_HACK = CLI.optionSet(JAVAHACK,opts);
        Inline.FOR_ALL = CLI.optionSet(FORALL,opts);
        // !Diff.optionSet("--noresidue");
        SubTyping.STRICT = CLI.optionSet(STRICT,opts);
        
        String header = (""+pack+IncludeCDs.allImports(CDs) + 
                (CDs.top().getPkg().hasPkg()?
                        "import "+CDs.top().getPkg().name()+".*;\n":""));
        
        return traversalClass(name,impl,header,types,subs,funClass,stClass,ctrl,targ,opts);
    }
    
    public static String traversalClass(String name, Impl impl, String header, List<TypeDef> types, SubTyping subs,
            String funClass, String stClass, GenControl ctrl, Option<TypeUse> targ, List<String> opts){ 
        String ret = null;
        TypeUse stUse = TypeUse.makeType(stClass);
        Typer typer = Checker.check(types,subs,funClass,stClass,ctrl,targ);
        List<EnvEntry> env = typer.results.toList();
        
        /*p(" Selections: \n"+env.toString(new List.Stringer<EnvEntry>(){
            public String toString(EnvEntry e, List<EnvEntry> r){
                return "    "+e.toString()+(e.getChoices().isEmpty()?"\n":"");
            }
        })+"\n");*/
        
        if(CLI.optionSet(JUSTTYPE,opts))System.exit(0);
        if(name.length() == 0){
            name = ("Inline"+(CLI.optionSet(HEAP,opts)?"Heap":((CLI.optionSet(PARALLEL,opts)?"Par":"")))+
                    removePack(funClass));
        }
        //System.err.println(" OPTIONS: "+opts);
        if(CLI.optionSet(HEAP,opts))ret = GenHeapTrav.generate(name,impl,types,funClass,stUse,ctrl,targ,env,subs,typer.updates,opts);
        else if(CLI.optionSet(PARALLEL,opts))ret = GenParTrav.generate(name,impl,types,funClass,stUse,ctrl,targ,env,subs,typer.updates,opts);
        else ret = GenTrav.generate(name,impl,types,funClass,stUse,ctrl,targ,env,subs,typer.updates,opts);
        
        return Preamble.header+header+"\n"+ret+"\n";
    }

    static String removePack(String f){
        int idx = f.lastIndexOf('.');
        if(idx < 0)return f;
        return f.substring(idx+1);
    }
    
    static void error(Throwable t, String type){ error(t, type, false); }
    static void error(Throwable t, String type, boolean stack){
        p("\n !! "+type+" Error:\n"+t.getMessage()+"\n\n");
        if(stack)t.printStackTrace();
    }
    static void usage(String msg){
        p((msg.length()>0?" !! "+msg+"\n":"")+
                " !! Usage: Inline [Options] <CD-File> <FuncClass> <StartClass>\n\n"+
                "    The order/placement of options doesn\'t matter, but the relative\n"+
                "       order of the manditory ones must be as shown.\n\n"+
                "    CD-File contains the CD for the traversal to be checked/generated,\n"+
                "    FuncClass is the function class to be checked/inlined,\n"+
                "    StartClass class where traversal begins (source)\n"+
                "    Options can be: \n"+
                "      --targ:Class         : The superclass of all traversal contexts\n"+
                "      --path:P1:...:Pn     : A colon separated list of packages in which to\n"+
                "                               search for classes. E.g., \"--path:java.util:java.lang\"\n"+
                "      --builtin:C1:...:Cn  : A colon separated list classes to be considered BuiltIn\n"+
                "      --bypass:E1:...:En   : A list of edges to be bypassed: E.g., \"Class.field\"\n"+
                "      --justtype           : Only typecheck the traversal, and print the return selections\n"+
                "      --strict             : Be strict on number of function arguments\n"+
                "      --verbose            : Print out more information\n"+
                "      --javahack           : Support Java 'Type Erasure' in generaic subtyping\n"+
                "      --heap               : Generate Heap traversal rather than Stack\n"+
                "      --forall             : Create a traverse method for each concrete types\n"+
                "\n"
                );
        System.exit(1);
    }
}


class Help{
    //static boolean verbose = true;
    static boolean verbose = false;
    static void print(String s){ if(verbose)System.err.print(s); }
    static void tell(String s){ System.err.print(s); }
}
