package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.inline.classes.*;
import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.util.CLI;

import edu.neu.ccs.demeterf.demfgen.dgp.*;
import edu.neu.ccs.demeterf.demfgen.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;

public class GenParTrav{
    static final int DEF_THRESH = 2;
    static String generate(String name, Impl impl, final List<TypeDef> types, String func, TypeUse start, GenControl ctrl,
                           Option<TypeUse> targ, List<EnvEntry> choices, SubTyping subs,
                           Map<String,List<Meth>> updts, List<String> opts){
        
        final GenParInline gen = new GenParInline(func, targ, choices, subs, ctrl, updts, opts);
        String result = GenTrav.generateBody(gen,func,start,types);
        TypeUse ret = gen.findEntry(start).getRet();
        int defaultThresh;
        try{
            defaultThresh = Integer.parseInt(Diff.getOptionList(Diff.threshhold)[0]);
        }catch(RuntimeException e){
            defaultThresh = DEF_THRESH;
        }
        
        return
        "public class "+name+" "+ClassGen.unlocal(impl.print())+"{\n"+
        "   final int THRESHHOLD;\n"+
        "   final private "+ClassGen.unlocal(func)+" func;\n\n"+
        "   public "+name+"("+ClassGen.unlocal(func)+" f, int T){ func = f; THRESHHOLD = T; }\n"+
        "   public "+name+"("+ClassGen.unlocal(func)+" f){ this(f,"+defaultThresh+"); }\n\n"+
        result+
        "   static interface _Result<_R>{ _R result(); }\n"+
        "   static class _Trav<_R> implements _Result<_R>{\n"+
        "       final _R res;\n"+
        "       _Trav(_R r){ res = r; }\n"+
        "       public _R result(){ return res; }\n"+
        "   }\n"+
        "   static abstract class _ParTrav<_T,_R> extends Thread implements _Result<_R>{\n"+
        "       final _T tobj;\n"+
        "       final "+name+" trav;\n"+
        "       _R res = null;\n"+
        "       boolean done = false;\n"+
        (targ.isSome()?"       final "+ClassGen.unlocal(targ.inner())+" targ;\n":"")+
        "       _ParTrav(_T to, "+name+" t"+
        (targ.isSome()?", "+ClassGen.unlocal(targ.inner())+" ta":"")+"){\n"+
        "           tobj = to; trav = t; "+(targ.isSome()?" targ = ta; ":"")+"\n"+
        "           this.setPriority(Thread.NORM_PRIORITY-2);\n"+
        "           this.start();\n"+
        "       }\n"+
        "       public void run(){ setDone(traverse()); }\n"+
        "       synchronized void setDone(_R r){ res = r; done = true; this.notify(); }\n"+
        "       public synchronized _R result(){\n"+
        "           if(!done)\n"+
        "               try{ this.wait(); }catch(InterruptedException e){\n"+
        "                   System.err.println(\" ** Error Waiting on Thread!!\");\n"+
        "               }\n"+
        "           return res;\n"+
        "       }\n"+
        "       /** Do the Actual Traversal */\n"+
        "       public abstract _R traverse();\n"+
        "   }\n"+
        "}";
    }

    
    public static class GenParInline extends GenTrav.GenInline{
        List<String> parfields;
        List<String> partypes;
        boolean useThresh;
        
        public GenParInline(String f, Option<TypeUse> ta, List<EnvEntry> ch, SubTyping s, GenControl c,
                Map<String,List<Meth>> updts, List<String> opts){
            super(f, ta, ch, s, c, updts);
            parfields = List.create(CLI.separateOption(Inline.PARFIELDS,opts));
            partypes = List.create(CLI.separateOption(Inline.PARTYPES,opts));
            useThresh = parfields.isEmpty() && partypes.isEmpty();

            //System.err.println("FIELDS: "+parfields+"   TYPES: "+partypes);
            
            acc = new Decision.Access(){
                public String use(String f, String host, String typ){
                    boolean par = (parfields.contains(host+"."+f) || partypes.contains(""+typ)); 
                    return ((ctrl.isBuiltIn(typ) && !par) || (!par && !useThresh) || 
                            f.equals(GenTrav.targName) || f.equals(HOST))
                            ?f:("("+f+".result())");
                }
            };
        }

        String parTrav(String obj, String trav, String host, TypeUse tu, String ret, String f, String indnt){
            return ("new _ParTrav<"+tu+","+ret+">("+HOST+"."+getter(f)+",this"+targUse()+"){\n"+
                    indnt+"    public "+ret+" traverse(){ return "+obj+"."+trav+"; }\n"+
                    indnt+"}");
        }
        
        public String travMethod(TypeUse start){
            TypeUse ret = findEntry(start).getRet();
            return
            "   // New One...\n"+
            "   public "+ClassGen.unlocal(ret)+" traverse("+start+" "+HOST+targDef()+"){\n"+
            "       Thread.currentThread().setPriority(Thread.MAX_PRIORITY);\n"+
            "       "+ClassGen.unlocal(ret)+" ret = traverse"+Flds.addSpacers(start)+"("+HOST+
            (useThresh?", 0":"")+targUse()+");\n"+
            "       return ret;\n"+
            "   }\n";
        }
        
        public String extraDefs(){ return useThresh?", final int weight":""; }
        public String extraAbstrArgs(){ return useThresh?", weight":""; }
        public String extraConcrArgs(){ return useThresh?", weight+1":""; }
       
        public String builtinCall(String prefix, String host, TypeUse ftype, String fname, List<Meth> choices, String boxedRet){
            if(!(parfields.contains(host+"."+fname) || partypes.contains(""+ftype)))
                return super.builtinCall(prefix, host, ftype, fname, choices, boxedRet);
            String comb = "combine("+HOST+"."+getter(fname)+((choices.top().getArgs().length()>1)?", "+updateMethod(host, fname):"")+")";
            return ("_Result<"+boxedRet+"> _"+fname+" = "+parTrav("func",comb,host,ftype,boxedRet,fname,"        ")+";");
        }
        
        public String recurseCall(String prefix, String host, TypeUse ftype, String fname, List<Meth> choices, String boxedRet){
            String traverse = "traverse"+Flds.addSpacers(ftype)+"("+HOST+"."+getter(fname)+extraConcrArgs()+updateMethod(host, fname)+")";

            boolean par = (parfields.contains(host+"."+fname) || partypes.contains(""+ftype));
            if(!par && !useThresh)return prefix+traverse+";";
            
            return ("_Result<"+boxedRet+"> _"+fname+" = "+
                    (par?parTrav("trav",traverse,host,ftype,boxedRet,fname,"        "):
                        ("(weight!=THRESHHOLD)? new _Trav<"+boxedRet+">("+traverse+"): "+
                                parTrav("trav",traverse,host,ftype,boxedRet,fname,"        ")))+";");
        }
        
    }
}