package edu.neu.ccs.demeterf.http.server;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/** Attach a Server method to a given (relative) Path.  The signature
 *    of the method must be one of:
 *    <ul>
 *        <li><tt>public HTTPResp method()</tt></li>
 *        <li><tt>public HTTPResp method(HTTPReq)</tt></li></li>
 *        <li><tt>public HTTPResp method(HTTPReq, java.net.Socket)</tt></li></li>
 *    </ul>
 *  If no value is given (e.g., <tt>@Path()</tt>) then the method will
 *    become the default for unknown requests. 
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface Path{
    final String EMPTY = "";
    String value() default "";
}