package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.util.Util;

/** Test of new Method Warning. 
 *    <p>Util.setWarning(true) turns on warning messages for method
 *    selection.  When a method with more parameters is chosen over
 *    one with less but more specific parameters. </p>
 *
 *    <p>This may go away soon, as writing more specific parameters
 *    seems to be a better way of abstracting methods, but we still
 *    have to discover a better ranking system.</p>
 */
public class WarningTest{

    static class X{
        Y y; Z z;
        X(Y yy, Z zz){ y = yy; z = zz; }
    }
    static class Y{}
    static class Z{}
    
    static class ABuilder extends ID{
        // This one is not chosen...
        int combine(X x, Y y){ return 5; }

        // This one is instead...
        int combine(Object o, Object o2, Object o3){ return 7; }

        // This covers Y/Z cases
        Object combine(Object o){ return o; }
    }
    
    public static void main(String args[]){
        /// Warnings On...
        Util.setWarning(true);

        Traversal t = new Traversal(new ABuilder());        
        System.out.println(" Return: "+t.traverse(new X(new Y(), new Z())));
    }
}
