package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.util.Util;

/** Test for Void combine methods, providing Visitor like abstraction.
 *
 *  <p>When you don't want to eliminate side-effects, you can use
 *  "void" combine methods, and operate via mutation.  Here you ahould
 *  only match on the first argument, since the others might be "void",
 *  which currently returns the value "null".</p>
 *
 *  <p>Here we compute the length of a list through mutation of an
 *  instance variable.</a>
 */
public class VoidTest {
    public static void main(String as[]){
        L<Integer> lst = L.make(2, 4, 6, 8, 9, 7, 5, 3);
        Util.setAllowNull(true);
        System.out.println("   List: "+lst);
        System.out.println(" Length: "+new LenVis().traverse(lst));
    }

    // Lists: Cons | L  (supercalss becomes the empty list)
    static class L<X>{
        static <X> L<X> make(X ... xs){
            L<X> l = new L<X>();
            for(X x:xs)l = new C<X>(x,l);
            return l;
        }
        public String toString(){ return ""; }
    }
    static class C<X> extends L<X>{
        X first; L<X> rest;
        C(X f, L<X> r){ first = f; rest = r; }
        public String toString(){ return ""+first+", "+rest; }
    }
    
    // Visitor class... default is do nothing.
    //   assumed to operate via side-effects
    static abstract class Vis<X> extends ID{
        abstract X returnVal();
        void combine(){}
        X traverse(Object o){
            new Traversal(this).traverse(o);
            return returnVal();
        }
    }
    
    // Compute the length of a List
    static class LenVis extends Vis<Integer>{
        int len = 0;
        void combine(C l){ len++; }
        Integer returnVal(){ return len; }
    }
}