package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.ValueThrow;

/** Demonstration of the ValueThrow class */
public class TossExample {
    public static void p(String s){ System.out.print(s); }
    public static void main(String args[]){
        IntList list = IntList.create(5,2,4,3,6,9,8);
        
        p("   List: "+list+"\n");
        p(" Length: "+ValueThrow.traverse(new Traversal(new Len()), list, 0)+"\n");
    }
    
    public static class IntList{
        static IntList create(int ... a){
            IntList lst = new IntList();
            for(int i = 0; i < a.length; i++)
                lst = new IntCons(a[i], lst);
            return lst;
        }
        boolean isEmpty(){ return true; }
        public String toString(){ return ""; }
    }
    public static class IntCons extends IntList{
        int first;
        IntList rest;
        IntCons(int f, IntList r){ first = f; rest = r; }
        boolean isEmpty(){ return false; }
        public String toString(){ return "("+first+", "+rest+")"; }
        public static class rest{}
    }

    public static class Len extends ID{
        int update(IntCons c, IntCons.rest f, int len){ return len+1; }
        void combine(IntList c, int len){ ValueThrow.toss(len); }
    }
    
}
