package edu.neu.ccs.demeterf.examples;
import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/** Test of the RBTree library class.  Draws the tree to a frame using DemeterF
 *    traversal of course!  Uses the Augmentor (update) protocol to divide the
 *    canvas into two halves and draw a nice, pretty tree. Hit keys to see the
 *    ASCII codes added to the tree as it is automatically ballanced. */
public class RBTest{
    public static void main(String args[]){ new Frame(); }
    
    static class Frame extends JFrame{
        Frame(){
            super("Tree Test: Hit some keys!!");
            setSize(400,300);
            setLocation(50,50);
            setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            TC tc = new TC(); 
            getContentPane().add(tc);
            this.addKeyListener(tc);
            setVisible(true);
        }
        static class TC extends JComponent implements KeyListener{
            RBTree<Integer> tree = RBTree.create();
            public void paint(Graphics g){
                new Traversal(new Painter(g))
                .traverse(tree, new Painter.Trip(30,10,getWidth()));
            }
            public void keyPressed(KeyEvent ke){}
            public void keyReleased(KeyEvent ke){}
            public void keyTyped(KeyEvent ke) {
                char c = ke.getKeyChar();
                tree = (!ke.isAltDown())?tree.insert((int)c):tree.remove((int)c);
                repaint();
            }
        }
    }

    static class Painter extends ID{
        public static class Trip{
            int h,l,r;
            Trip(int hh, int ll, int rr){ h = hh; l = ll; r = rr; }
            int mid(){ return (l+r)/2; }
        }
        Graphics g;
        Painter(Graphics gg){ g = gg; }
        
        Trip update(RBNode n, RBNode.left f, Trip t){ return new Trip(t.h+60,t.l,t.mid()); }
        Trip update(RBNode n, RBNode.right f, Trip t){ return new Trip(t.h+60,t.mid(),t.r); }
        int combine(RBNode n, Color c, int i, int l, int r, Trip p){
            g.setColor(c);
            g.fillOval(p.mid()-15, p.h, 30, 30);
            String s = ""+(char)i;
            g.setColor(Color.white);
            g.drawChars(s.toCharArray(), 0, s.length(), p.mid()-(4*s.length()), p.h+20);
            return 0;
        }
        int combine(RBLeaf<Integer> n, Trip p){
            g.setColor(Color.black);
            g.fillOval(p.mid(), p.h, 5, 5);
            return 0;
        }
        Color combine(RBColor c){ return c.isBlack()?Color.black:Color.red; }
    }
}