package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.lib.List;

public class ListTest {
    static void p(String s){ System.out.println(s); }
    public static void main(String[] args){
        List<String> l = List.create("A","B","C","D","E");
        for(String s:l)p("      El: "+s);
        
        List<Integer> ints = List.buildlist(new List.Build<Integer>(){
            public Integer build(int i){ return (int)(Math.random()*20); }
        }, 10);
        p("   Ints: "+ints);
        p(" Zipped: "+l.zip(new List.Zip<String,Integer,String>(){
            public String zip(String s, Integer i){ return s+":"+i; }
        }, ints));
        p(" Sorted: "+ints.sort(new List.Comp<Integer>(){
            public boolean comp(Integer i, Integer j){ return i<=j; }
        }));
        
        p(" Replace: "+l.replace(1,"Z"));
    }
}
