package edu.neu.ccs.demeterf.examples;
import edu.neu.ccs.demeterf.*;
import java.util.Arrays;

/**  Test of Array support.  Arrays are handled similar to map; each index is
 *     recursively traversed, and the results are combined into an array, whose
 *     runtime type is the nearest bound (possibly Object) for all the new
 *     elements.  Below we produce an Array of Strings from the two different
 *     Arrays (R[] and T[]). */
public class ArrayTest {
    static void p(String s){ System.out.println(s); }
    public static void main(String args[]){
        R r = new R();
        Q q = new Q(new S(), new R[]{r,r,r,r});
        
        Traversal t = new Traversal(new ID(){
            String combine(S s){ return "S"; }
            String combine(R s){ return "R"; }
            String combine(Q q, String s, String[] rs){
                return "Q("+s+", "+Arrays.toString(rs)+")";    
            }});
        
        // Prints " Returned: Q(S, [R, R, R, R])"
        p(" Returned: "+t.traverse(q));

        // Prints " Map: [R, S, R, S]"
        p(" Map: "+Arrays.toString(t.<String[]>traverse(new T[]{r, new S(),
                                                                r, new S()})));
    }
    
    static class Q{
        S s; R r[];
        Q(S ss, R rr[]){ s = ss; r = rr; }
    }
    static class T{}
    static class R extends T{}
    static class S extends T{}
}
