package edu.neu.ccs.demeterf.dispatch;

import java.util.Arrays;

/** DBEntry is a generic Class that wraps a 'method' (or any kind of
 *    related signature class) for inclusion in a MethodDB list. */
public class DBEntry<M>{
    private static Class<Object> object = Object.class;
    private M method;
    private String name;
    private Class<?>[] argTypes;
    private Class<?> retType;
    
    /** Create a DBEntry from an M, a Return Type and a List of Argument Types */
    public DBEntry(M m, String n, Class<?> ret, Class<?>[] args){
        method = m;
        name = n;
        retType = ret;
        argTypes = Type.fromClassArray(args);
    }
    
    /** Get the Method that this DBEntry Holds */
    public M getMethod(){ return method; }
    /** Return the number of arguments for this entry */
    public int numArgs(){ return argTypes.length; }
    /** Return the i<sup>th</sup> argument of this entry */
    public Class<?> arg(int i){
        if(i < numArgs())return argTypes[i];
        return object;
    }
    /** Return the return type of this entry */
    public Class<?> retType(){ return retType; }
    /** Is this DBEntry equal to the given Object? */
    public boolean equals(Object o){
        return ((o instanceof DBEntry) && 
                Arrays.deepEquals(argTypes, ((DBEntry)o).argTypes));
                //&& retType.equals(((DBEntry)o).retType));
    }
    /** Return this DBEntry's HashCode */
    public int hashCode(){
        return Arrays.deepHashCode(argTypes)+retType.hashCode()*17;
    }
    /** Return the String representation of this DBEntry */
    public String toString(){
        String ret = retType.getSimpleName()+" "+name+"(";
        for(int i = 0; i < argTypes.length; i++){
            ret += argTypes[i].getSimpleName();
            if(i < argTypes.length-1)ret += ", "; 
        }
        return ret+")";
    }
}