/**
 *  DemeterF <i>per-class DGP</i> classes.
 *  <p>
 *  The class PCDGPFunc can be extended to implement functionality for all
 *    the classes in a given CD, generated on a <i>per-class</i> basis.  This
 *    is done with a DemeterF traversal over each <tt>TypeDef</tt> from the CD.
 *    The structures involved are defined in the demfgen CD file:<br> 
 *    &nbsp;&nbsp;&nbsp;<tt>edu/neu/ccs/demeterf/demfgen/demfgen.cd</tt><br>
 *  </p>
 *  
 *  <p>
 *  The provided PCDGP functions are as follows:
 *    <ul>
 *    <li><tt>Getters</tt>: </li>
 *    <li><tt>Updaters</tt>: </li>
 *    <li><tt>Setters</tt>: </li>
 *    <li><tt>Creator</tt>: </li>
 *    </ul>
 *  </p>
 *  
 *  <p>
 *  The functions to be generated are specified as an argument to DemeterF with
 *    the option: <tt>--pcdgp:</tt> immediately followed by a list of PCDGPFunc class
 *    names separated by colons (":").
 *  </p>
 *  
 *  <p><h3>Example:</h3>
 *  <blockquote>
 *     CD: pcdgp.cd
 *      <pre>
 *        MainC = &lt;i&gt; int &lt;d&gt; double.
 *      </pre><br>
 *     
 *     Build With:
 *     <pre>
 *        Java:  java demeterf pcdgp.cd any.beh ./ --pcdgp:Getters
 *          C#:  java demeterfcs pcdgp.cd any.beh ./ --pcdgp:Getters
 *     </pre><br>
 *     
 *     Generated Class Snipet (For Both):
 *     <pre style="border:solid blue 1px;margin-left:60px;width:400px;">
 *        public class MainC{
 *            protected final int i;
 *            protected final double d;
 *    
 *            /** Other ... Stuff * /
 *    
 *            /** Getter for field MainC.d * /
 *            public double getD(){ return d; }
 *            /** Getter for field MainC.i * /
 *            public int getI(){ return i; }
 *        }
 *     </pre><br>
 *  </blockquote>
 *  
 *  See individual source files for more details.
 *  
 *  </p>
 */

package edu.neu.ccs.demeterf.demfgen.pcdgp;