package edu.neu.ccs.demeterf.demfgen.pcdgp;

import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.StrLTrip.StrPair;
import edu.neu.ccs.demeterf.lib.Cons;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.util.Util;

/**  */
public class Updaters extends Getters{
    public Updaters(List<String> sFs){ super(sFs); }
    public FC functionObj(List<String> superFs){ return new Updaters(superFs); }
    
    public String combine(ClassDef td, DoGen g, final ident n, TypeDefParams ps, Cons<String> sts, final List<StrPair> fs){
        final String type = ""+n+ps;
        return fs.foldl(new List.Fold<StrPair, String>(){
            public String fold(StrPair p, String r){
                String override = superFs.contains(p.b)?Diff.d.override:"";
                return r+("    /** Abstract updater for field "+n+"."+p.b+" */\n"+
                        "    public"+override+" abstract "+type+" "+Diff.capName("update"+Util.capCase(p.b))+"("+p.n+" _"+p.b+");\n");
            }
        }, "");
    }
    public String combine(ClassDef td, DoGen g, final ident n, TypeDefParams ps, Empty<String> sts, final List<StrPair> fs){
        final String type = ""+n+ps;
        return fs.foldl(new List.Fold<StrPair, String>(){
            int i = -1;
            public String fold(StrPair p, String r){
                i++;
                String override = superFs.contains(p.b)?Diff.d.override:"";
                return r+("    /** Updater for field "+n+"."+p.b+" */\n"+
                        "    public"+override+" "+type+" "+Diff.capName("update"+Util.capCase(p.b))+"("+p.n+" _"+p.b+"){\n"+
                        "        return new "+type+"("+
                        fieldNames(fs.replace(i, new StrPair(p.n,"_"+p.b)))+");\n"+
                        "    }\n");
            }
        }, "");
    }
}
