package edu.neu.ccs.demeterf.demfgen.pcdgp;

import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.StrLTrip.StrPair;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.ident;

/**  */
public abstract class Typical extends PCDGPFunc{
    protected final List<String> superFs;
    protected Typical(List<String> sFs){ superFs = sFs; }
    
    public Control control(){ return Control.builtins(TypeDefParams.class,
            ident.class, TypeUse.class, Impl.class, Syntax.class); }
    
    public abstract String combine(ClassDef td, DoGen g, ident n, TypeDefParams ps, List<String> sts, List<StrPair> fs);
    public String combine(IntfcDef td){ return ""; }
    public String fieldArgs(List<StrPair> fs){
        return fs.map(new List.Map<StrPair, String>(){
            public String map(StrPair p){ return p.n+" "+p.b; }
        }).toString(", ", "");
    }
    public String fieldNames(List<StrPair> fs){
        return fs.map(new List.Map<StrPair, String>(){
            public String map(StrPair p){ return p.b; }
        }).toString(", ", "");
    }
    public TypeDefParams combine(EmptyDefParams e){ return e; }
    public <X> List<X> combine(EmptyList e){ return List.create(); }
    public <X> List<X> combine(ConsList c, X f, List<X> r){ return r.push(f); }
    public <X> List<X> combine(ConsList c, Syntax f, List<X> r){ return r; }
    public StrPair combine(Field f, ident n, String type){
        return new StrPair(type, ""+n);
    }
    public String combine(TypeUse tu){ return ""+tu; }
}
