package edu.neu.ccs.demeterf.demfgen.pcdgp;

import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.StrLTrip.StrPair;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.util.Util;

/**  */
public class Setters extends Typical{
    public Setters(List<String> sFs){ super(sFs); }
    public FC functionObj(List<String> superFs){
        if(!Diff.optionSet(Diff.mutable))
            throw new RuntimeException("PCDGP Error: Setters requires the '--mutable' option");
        return new Setters(superFs);
    }
    public String combine(ClassDef td, DoGen g, final ident n, TypeDefParams ps, List<String> sts, List<StrPair> fs){
        final boolean abst = !sts.isEmpty();
        return fs.foldl(new List.Fold<StrPair, String>(){
            public String fold(StrPair p, String r){
                String override = superFs.contains(p.b)?Diff.d.override:"";
                return r+("    /** Setter for field "+n+"."+p.b+" */\n"+
                        "    public"+override+(abst?" abstract":"")+" void "+Diff.capName("set"+Util.capCase(p.b))+
                        "("+p.n+" _"+p.b+")"+(abst?";":"{ "+p.b+" = _"+p.b+"; }\n"));
            }
        }, "");
    }
}
