package edu.neu.ccs.demeterf.demfgen.pcdgp;

import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.lib.List;

/** The base class of Per Class Data-Generic Function generation. PCDGP Functions
 *    traverse a single TypeDef returning a String representing a method to be placed
 *    in the body of a the type's class definition. */
public abstract class PCDGPFunc extends FC{
    /** Need this one for the whole thing to work right... */
    public PCDGPFunc(){ }
    
    /** The function object responsible for function generation */
    public abstract FC functionObj(List<String> superFs);
    /** Traversal control for this function generation */
    public Control control(){ return Control.everywhere(); }
}
