package edu.neu.ccs.demeterf.demfgen.dgp.traversals;

import edu.neu.ccs.demeterf.demfgen.dgp.*;

/** Represents a little traversal factory, so there's a central place to
 *    switch from reflective to inlined/generated traversals. The traversal factories
 *    are placed in the following classes:
 *    <ul>
 *       <li><code>edu.neu.ccs.demeterf.demfgen.Factory</code></li>
 *       <li><code>edu.neu.ccs.demeterf.demfgen.traversals.Travs</code></li>
 *       <li><code>edu.neu.ccs.demeterf.demfgen.dgp.traversals.Travs</code></li>
 *    </ul>
 */
public class Travs{
    //public static Travs TheFactory = new Travs();
    public static ReflectiveTraversals TheFactory = new ReflectiveTraversals();
    
    public PrintTrav makePrintTrav(Print f){ return new PrintTrav(f); }
    public TravGenericTrav makeTravGenericTrav(TravGeneric f){ return new TravGenericTrav(f); }
    public StaticTravTrav makeStaticTravTrav(StaticTrav f){ return new StaticTravTrav(f); }
}
