package edu.neu.ccs.demeterf.demfgen.dgp.sql;

import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.lib.List;

public class SQLUtil{
    public static List<String> sqltypes = List.create("TINYINT","SMALLINT","INT","INT", 
                                        "FLOAT","DOUBLE","CHAR(1)","BOOLEAN",
                                        "TEXT","TEXT","TEXT");

    public static String sqlType(String t){
        String tstr = Diff.d.box(t);
        tstr = Diff.d.boxed.contains(tstr)?
            sqltypes.lookup(Diff.d.boxed.index(tstr)):"INT";
        return tstr;
    }

    public static String createTable(String name, List<String> fs){
        return ("   create table "+name+"(\n"+
                "      __objid INT not null,\n"+
                fs.toString(" not null,\n","      ")+
                (fs.isEmpty()?"":" not null,\n")+
                "      PRIMARY KEY(__objid)"+
                "\n   ) engine = MyISAM;\n\n");
    }
}