/**
 *  DemeterF <i>datatype generic programming</i> classes and interfaces.
 *  <p>
 *  The class DGPFunc can be extended to implement functionality over <i>all</i>
 *    the classes in a given CD.  This is done with a DemeterF traversal over all
 *    <tt>TypeDef</tt>s in the CD.
 *    The structures involved are defined in the demfgen CD file:<br> 
 *    &nbsp;&nbsp;&nbsp;<tt>edu/neu/ccs/demeterf/demfgen/demfgen.cd</tt><br>
 *  </p>
 *  
 *  <p>
 *  DGPFunc implements the default usage, which introduces a no argument method
 *    with the same name as the class name in C#; when generating Java the first
 *    letter of the name is in lowercase. (e.g., Print -> public String print(){...}).
 *    Various methods in the base class affect how the methods are generated and how
 *    the CD-of-CDs is traversed. See the source for classes
 *    <tt>Concrete/Print/Display/ToStr</tt> and others for details. 
 *  </p>
 *  
 *  <p>
 *  There are multiple examples of useful functions including <tt>Print</tt>,
 *    <tt>ToStr</tt>, and <tt>Display</tt>, which are almost exactly the same
 *    as the corresponding visitors in <tt>DemeterJ</tt>. The provided DGP
 *    functions are as follows:
 *    <ul>
 *    <li><tt>Print</tt>: includes syntax and notations from the CD file (such as *s,
 *        +, -, and *l) to pretty print an instance of the defined classes.</li>
 *    <li><tt>PrintToString</tt>: same as <tt>Print</tt>, but the resulting function is named
 *    <li><tt>PrintHeap</tt>/<tt>PrintHeapToString</tt>: </li>
 *        <tt>toString</tt> (<tt>ToString</tt> in C#) to support automatic string conversion.</li> 
 *    <li><tt>Display</tt>/<tt>DisplayToString</tt>: returns a string with nested objects including field/class names.
 *        The same as the DemeterJ <tt>DisplayVisitor</tt>, but <b>returns</b> the string to be
 *        displayed.</li> 
 *    <li><tt>ToStr</tt>/<tt>ToString</tt>: Returns a simple nested (functional looking) representation of
 *        each object. Useful for simple tests/debugging.</li>
 *    <li><tt>ToXML</tt>: </li>
 *    <li><tt>HashCode</tt>: </li>
 *    <li><tt>StaticTrav</tt>: </li>
 *    <li><tt>StaticTravCtx</tt>: </li>
 *    <li><tt>StaticBC</tt>: </li>
 *    <li><tt>StaticTU</tt>: </li>
 *    </ul>
 *  </p>
 *  
 *  <p>
 *  The functions to be generated are specified as an argument to DemeterF with
 *    the option: <tt>--dgp:</tt> immediately followed by a list of DGPFunc class
 *    names separated by colons (":").
 *  </p>
 *  
 *  <p><h3>Example:</h3>
 *  <blockquote>
 *     CD: main.cd
 *      <pre>
 *        MainC = &lt;a&gt; A.
 *        A = "(" + *l &lt;b&gt; B *l &lt;c&gt; C - *l ")".
 *        B = "Bee" *s &lt;i&gt; int.
 *        C = "Cee" *s &lt;s&gt; String.
 *      </pre><br>
 *      
 *     BEH (Java): main.beh
 *     <pre> 
 *        MainC{{
 *          public static void main(String[] s) throws Exception{
 *            MainC m = MainC.parse("(Bee -54 Cee \"Test\")");
 *            System.out.println("\nPrint:\n"+m.print());
 *            System.out.println("\nDisplay:\n"+m.display());
 *          }
 *        }}
 *      </pre><br>
 *      
 *     BEH (C#): main.cs.beh
 *     <pre> 
 *        MainC{{
 *          public static void Main(String[] s){
 *            MainC m = MainC.parse("(Bee -54 Cee \"Test\")");
 *            Console.WriteLine("\nPrint:\n"+m.Print());
 *            Console.WriteLine("\nDisplay:\n"+m.Display());
 *          }
 *        }}
 *     </pre><br>
 *     
 *     Build With:
 *     <pre>
 *        Java:  java demeterf main.cd main.beh ./ --build --dgp:Print:Display
 *          C#:  java demeterfcs main.cd main.cs.beh ./ --build --dgp:Print:Display
 *     </pre><br>
 *     
 *     Run With:
 *     <pre>
 *        Java:  java MainC
 *          C#:  ./MAIN.exe
 *     </pre><br>
 *     
 *     Output (For Both):
 *     <pre style="border:solid blue 1px;margin-left:60px;width:400px;">
 * 
 *   Print:
 *   (
 *      Bee -54
 *      Cee "Test"
 *   )
 *
 *   Display:
 *   : MainC (
 *      &lt;a&gt; : A (
 *        &lt;b&gt; : B (
 *            &lt;i&gt; : int "-54" )
 *        &lt;c&gt; : C (
 *            &lt;s&gt; : String "Test" ) ) )
 *  </pre><br>
 *  </blockquote>
 *  
 *  See individual source files for more details.
 *  
 *  </p>
 */

package edu.neu.ccs.demeterf.demfgen.dgp;