package edu.neu.ccs.demeterf.demfgen.dgp;

import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.ident;

/**  */
public class ToXML extends Display{
    public ToXML(){ this(""); }
    public ToXML(String beh){ super(beh); }
    public ToXML functionObj(String beh){ return new ToXML(beh); }
    public String docComment(){ return "Computes an XML String representation"; }
    
    public String primitive(String p){ return method(p, new EmptyDefParams(),List.<String>create(), true); }
    
    public String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, List<String> sts, List<String> fields){
        if(sts.length() > 0)return "";
        return method(""+n,dp,fields,false);
    }
    
    String method(String typ, TypeDefParams dp, List<String> flds, boolean prim){
        return ("   public String combine("+argType(typ,dp)+" _h_"+
                flds.toString("",", String ")+", String _d_)\n   {"+
                " return \"\\n\"+_d_+\"<"+typ.toLowerCase()+">\""+
                (prim?"+"+wrapStr(typ, "_h_"):flds.toString("","+"))+"+"+
                ((flds.isEmpty() || prim)?"":"\"\\n\"+_d_+")+
                "\"</"+typ.toLowerCase()+">\"; "+
                " }\n");
    }
}
