package edu.neu.ccs.demeterf.demfgen.dgp;
import edu.neu.ccs.demeterf.demfgen.classes.*;

import edu.neu.ccs.demeterf.lib.*;

/** Generate a CD specific TP for the given CD */
public class StaticTP extends StaticTrav{
    public StaticTP(){ this(""); }
    public StaticTP(String beh){ super(beh); }
    public StaticTP functionObj(String beh){ return new StaticTP(beh); }
    public String docComment(){ return "Creates a Static version of the TP class for a specific CD"; }
    public String superClass(){ return "edu.neu.ccs.demeterf.FC"; }
    
    public List.GComp<TypeUse,TypeDef> genericComp(){
        return TravGeneric.genericByNameForNoFields();
    }
    public String combine(Some<List<TypeDef>> some, String s){
        return finish(some.inner(),"",s);
    }
    public String[] builtins(){ return new String[0]; }
    
    public String primitive(String p){
        return "   public "+p+" combine("+p+" _h_){ return _h_; }\n";
    }

    public String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, Empty<TypeUse> sts, Flds fs){
        String host = Concrete.argType(n,dp);
        return ("   public "+host+" combine("+host+
                " _h_"+fs.formArgs()+"){\n"+
                "      return new "+host+"("+fs.callArgs(false)+");\n"+
                "   }\n");
    }
    public String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, List<TypeUse> un){ return ""; }   
    public String combine(IntfcDef td, DoGen g, ident n, TypeDefParams dp, List<TypeUse> un){ return ""; }
}