package edu.neu.ccs.demeterf.demfgen.dgp;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.lib.*;

/**  */
public class PrintHeap extends Concrete{
    public PrintHeap(){ this(""); }
    public PrintHeap(String beh){ super(beh); }
    public PrintHeap functionObj(String beh){ return new PrintHeap(beh); }
    public String docComment(){ return "Computes a String representation in CD Syntax, using limited Stack"; }
    public String primitive(String p){
        return "   public "+SBClass+" combine("+p+" _h_){ return new "+SBClass+"("+wrapStr(p,"_h_")+"); }\n";
    }
    
    public List.GComp<TypeUse,TypeDef> genericComp(){
        return TravGeneric.genericByNameOnly();
    }
    
    String SBClass = (Diff.d.isJava()?"StringBuffer":"System.Text.StringBuilder");
    
    public String combine(Some<List<TypeDef>> some, String s){
        String pre = "";
        String body = s;
        return finish(some.inner(), pre, body+Diff.d.escapeMethods);
    }
    
    static class FN extends Syntax{
        String id; FN(String i){ id = i; }
        public String toString(){ return id; }
    }
    public Syntax combine(Syntax t){ return t; }
    public Syntax combine(Field f, ident id, TypeUse t){ return new FN(""+id);}

    public String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, List<String> sts, List<Syntax> bdy){
        List.Pred<Syntax> p = new List.Pred<Syntax>(){
            public boolean huh(Syntax s){ return s instanceof FN; }
        };
        List<Syntax> fields = bdy.filter(p);
        return ("   public "+SBClass+" combine("+argType(n,dp)+" _h_"+
                fields.toString("",", "+SBClass+" ")+"){\n"+
                "      return new "+SBClass+"(\"\")"+fold(bdy)+";\n"+
                "   }\n");
    }

    static ID folder = new ID(){
        F combine(Cons<Syntax> c, AddToken t, F r){ return r.token(t.getStr()); }
        F combine(Cons<Syntax> c, AddSpace s, F r){ return r.token(" "); }
        F combine(Cons<Syntax> c, AddTab t, F r){ return r.token("    "); }
        F combine(Cons<Syntax> c, AddLine t, F r){ return r.token("\\n"); }
        F combine(Cons<Syntax> c, AddReturn t, F r){ return r.token("\\r"); }
        F combine(Cons<Syntax> c, Syntax s, F r){ return r; }
        F combine(Cons<Syntax> c, FN t, F r){ return r.field(t.id); }
        F combine(Empty<Syntax> e){ return new F(); }
    };
    
    static class F{
        String curr;
        List<String> tokens;
        F(){ this("",List.<String>create()); }
        F(String c, List<String> ts){ curr = c; tokens = ts; }
        F token(String s){ return new F(s+curr,tokens); }
        F field(String f){ return new F("",result().push(f)); }
        List<String> result(){ return curr.length() == 0?tokens:tokens.push("\""+curr+"\""); }
    }
    
    static String fold(List<Syntax> bdy){
        List<String> toks = new Traversal(folder, Control.builtins(Syntax.class))
                                    .<F>traverse(bdy).result();
        return toks.foldr(new List.Fold<String, String>(){
            public String fold(String s, String r){ return ".append("+s+")"+r; }
        },"");
    }
    public String stubMethodBody(){
        return ("return new edu.neu.ccs.demeterf.stackless.HeapTrav(new "+
                fileName()+"(),edu.neu.ccs.demeterf.Control.builtins("+wrap(builtins())+"))."+
                Diff.d.paramMethod("traverse",SBClass)+"(o).toString();");
    }
    public String methodName(){ return Diff.capName("Print"); }
}
