package edu.neu.ccs.demeterf.demfgen.dgp;

import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.lib.*;

/**  */
public class Display extends ToStr{
    public Display(){ this(""); }
    public Display(String beh){ super(beh); }
    public Display functionObj(String beh){ return new Display(beh); }
    
    public String docComment(){ return "Computes a nested String representation with field names and values"; }
    
    public String primitive(String p){
        return "   public String combine("+p+" _h_){ return \": "+p+" \"+"+wrapStr(p,"_h_")+"; }\n";    
    }
    
    public String combine(Some<List<TypeDef>> some, String s){
        return finish(some.inner(),"",
                "\n   public String update(Object o, Fields.any f, String d){ return d+\"   \"; }\n"+
                Diff.d.escapeMethods+"\n\n"+s);
    }

    public String combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, List<String> sts, List<String> fields){
        if(sts.length() > 0)return "";
        return ("   public String combine("+argType(n,dp)+
                " _h_"+fields.toString("",", String ")+", String _d_){\n"+
                "      return \": "+n+" (\"+"+fields.toString(new Str())+"\" )\";\n"+
                "   }\n");
    }
    
    class Str extends List.Stringer<String>{
        public String toString(String f, List<String> r){ return "\"\\n\"+_d_+\"<"+f+"> \"+"+f+"+"; }        
    }
    public boolean hasArgument(){ return true; }
    public String argument(){ return "\"   \""; }
}
