package edu.neu.ccs.demeterf.demfgen.dgp;

import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.demfgen.Factory;

/** Generate a CD specific TP for the given CD */
public class CDStats extends DGPFunc{
    public CDStats(){ super(""); }
    public CDStats(String beh){ super(beh); }
    public CDStats functionObj(String beh){ return new CDStats(); }
    public String docComment(){ return "Collects Stats for the CD(s)"; }
    public Control control(){
        return baseControl().addBuiltIns(TypeDefParams.class,TypeUseParams.class,
                TypeUse.class,FieldList.class,Impl.class,DoGen.class);    
    }
    
    public Trav traversalObj(final String beh)
    { return wrapTrav(Factory.newTraversal(functionObj(beh), control())); }
    
    public String fileSuffix(){ return "txt"; }
    
    public String combine(Some<List<TypeDef>> some, String s){ return ""; }
    public String combine(Some<List<TypeDef>> some, Stats s){ return s.toString(); }
    public String header(String com, PackageDef pkg, String cdImports){ return com; }
    public String stubMethod(){ return ""; }
    public String method(String pkg){ return ""; }
    
    Stats combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, Empty<TypeUse> sts, FieldList fs){
        return new Stats(fs.toList().length(),n.toString(),0,"");
    }
    Stats combine(ClassDef td, DoGen g, ident n, TypeDefParams dp, List<TypeUse> un){ return subtypes(un,n); }   
    Stats combine(IntfcDef td, DoGen g, ident n, TypeDefParams dp, List<TypeUse> un){ return new Stats(); }
    
    List<TypeUse> combine(ConsList un, TypeUse f, List<TypeUse> r){ return r.push(f); }
    List<TypeUse> combine(SubtypeEmpty e){ return List.create(); }
    Stats combine(Cons<TypeDef> c, Stats a, Stats b){ return a.combine(b); }
    Stats combine(Empty<TypeDef> e){ return new Stats(); }
    
    Stats subtypes(List<TypeUse> t, ident n){ return new Stats(0,"", t.length(),n.toString()); }
    static class Stats{
        Stats(){ this(0,"",0,""); }
        Stats(int flds, String fc, int sts, String sc){
            fields = flds; subts = sts; fclass = fc; sclass = sc; }
        final int fields, subts;
        final String fclass, sclass;
        
        public String toString(){
            return "\nMax Fields ("+fclass+") = "+fields+
                   "\nMax Subtypes ("+sclass+") = "+subts+"\n";    
        }
        Stats combine(Stats b){
            return new Stats(Math.max(fields,b.fields), fields>=b.fields?fclass:b.fclass,
                    Math.max(subts,b.subts), subts>=b.subts?sclass:b.sclass);
        }
    }
}