package edu.neu.ccs.demeterf.demfgen;

import edu.neu.ccs.demeterf.demfgen.classes.*;
import edu.neu.ccs.demeterf.lib.List;

/**  */
public class StrLTrip{
    static List<String> empty = List.<String>create();
    public List<String> fTypes, assigns, fNames;
    public StrLTrip(){ this(empty, empty, empty); }
    public StrLTrip(List<String> ft, List<String> as, List<String> fn){
        fTypes = ft; assigns = as; fNames = fn;
    }
    public boolean isEmpty(){ return fTypes.isEmpty(); }
    
    public StrLTrip add(String ft, String a, String fn){
        return new StrLTrip(fTypes.push(ft), assigns.push(a), fNames.push(fn));
    }
    public StrLTrip add(String a){
        return new StrLTrip(fTypes, assigns.push(a), fNames);
    }
    public StrLTrip append(StrLTrip st){
        return new StrLTrip(fTypes.append(st.fTypes), assigns.append(st.assigns), fNames.append(st.fNames));
    }
    public String fieldDefs(String priv){
        return fTypes.toString(";\n","    "+priv+" ")+(fTypes.isEmpty()?"":";\n");    
    }
    public String arguments(){ return fTypes.toString(", ",""); }
    public String assignments(){ return assigns.toString("\n","        "); }
    public String fieldToStrings(){ return fNames.toString("+\", \"+",""); }
    public String fieldClasses(final String parent){
        final String inner = Diff.d.fieldClassPost+" "+Diff.d.inherit+" edu.neu.ccs.demeterf.Fields.any{}";
        //return fNames.toString(inner,"\n    public"+Diff.d.fieldClassMod+" class ")+
        //(fNames.isEmpty()?"":inner);
        return fNames.toString(new List.Stringer<String>(){
            public String toString(String f, List<String> r){
                return ("\n    /** Field Class for "+parent+"."+f+" */"+
                        "\n    public"+Diff.d.fieldClassMod+" class "+f+inner);
            }
        });
    }
    //public String fieldEquals(){ return fNames.toString(new EqStringer()); }

    public static class StrTrip{
        public String f, t, a;
        public StrTrip(String ff, String aa, String tt)
        { f = ff; t = tt; a = aa; }
        public String toString(){ return "StrTrip("+f+","+t+","+a+")"; }
    }

    public static class StrPair{
        public String n, b;
        public StrPair(String nn, String bb)
        { n = nn; b = bb; }
        public String toString(){ return "StrPair("+n+","+b+")"; }
    }
}