package edu.neu.ccs.demeterf.control;

import edu.neu.ccs.demeterf.Control;

public abstract class MutableControl extends Control{
    /** Adds the given Class/Field to be Bypassed */
    public abstract MutableControl addBypassing(Class<?> c, String f);
    /** Adds the given Edge to be Bypassed */
    public abstract MutableControl addBypassing(Edge e);
    /** Adds all immediate fields of the given Class to be Bypassed */
    public abstract MutableControl addBypassing(Class<?> c);
    
    /** Removes the given Class/Field from the Bypassed list */
    public abstract MutableControl removeBypassing(Class<?> c, String f);
    /** Removes the given Edge from the Bypassed list */
    public abstract MutableControl removeBypassing(Edge e);
    
    
    /** Adds the given Class as a Builtin*/
    public abstract MutableControl addBuiltIn(Class<?> c);
    /** Add a Number of Classes to be considered Primitives */
    public abstract MutableControl addBuiltIns(Class<?> ... cs);
    
}
