package edu.neu.ccs.demeterf.compose;

import edu.neu.ccs.demeterf.*;

abstract class Exp{}
class Op extends Exp{ Exp l, r; Op(Exp ll, Exp rr){ l=ll; r=rr; } }
class AddOp extends Op{ AddOp(Exp l, Exp r){ super(l,r); } }
class LessOp extends Op{ LessOp(Exp l, Exp r){ super(l,r); } }
class AndOp extends Op{ AndOp(Exp l, Exp r){ super(l,r); } }
class Not extends Exp{ Exp e; Not(Exp ee){ e = ee; }}
class Int extends Exp{ int i; Int(int ii){ i = ii; } }

abstract class Type{
    static Type intt = new IntT(),
                boolt = new BoolT(),
                error = new ErrT();
    abstract String name();
    public String toString(){ return name(); }
}
class IntT extends Type{ String name(){ return "int"; }}
class BoolT extends Type{ String name(){ return "bool"; }}
class ErrT extends Type{ String name(){ return "error"; }}

public class Test {
    static void p(String s){ System.out.print(s); }
    public static void main(String args[]) throws Exception{ 
        Exp e = new Not(new AndOp(new LessOp(new AddOp(new Int(4), new Int(3)),new Int(8)),
                                  new LessOp(new Int(10), new Not(new Int(11)))));
        Object p[] = new CompTraversal(new Functor(new TC()),
                                       new Functor(new Str())).traverse(e);
        p("  Exp: "+p[1]+"\n");
        p(" Type: "+p[0]+"\n");
        if(p[0] != Type.error)
            p(" Eval: "+new Traversal(new Eval()).traverse(e)+"\n");
    }
}

class Str extends ID{
    String combine(AddOp e, String l, String r){ return "(+ "+l+" "+r+")"; }
    String combine(AndOp e, String l, String r){ return "(&& "+l+" "+r+")"; }
    String combine(LessOp e, String l, String r){ return "(< "+l+" "+r+")"; }
    String combine(Not e, String ee, IntT t){ return "(- "+ee+")"; }
    String combine(Not e, String ee, BoolT t){ return "(! "+ee+")"; }
    String combine(Int e, int i){ return ""+i; }
}

class Eval extends ID{
    Boolean combine(AndOp o, boolean l, boolean r){ return l&&r; }
    Integer combine(AddOp o, int l, int r){ return l+r; }
    Boolean combine(LessOp o, int l, int r){ return l<r; }
    Integer combine(Not e, int i){ return -i; }
    Boolean combine(Not e, boolean b){ return !b; }
    Integer combine(Int e, int i){ return i; }
}

class TC extends ID{
    Type combine(AndOp o, BoolT l, BoolT r){ return Type.boolt; }
    Type combine(AddOp o, IntT l, IntT r){ return Type.intt; }
    Type combine(LessOp o, IntT l, IntT r){ return Type.boolt; }
    Type combine(Op o){ return Type.error; }
    Type combine(Not e, Type i){ return i; }
    Type combine(Int e){ return Type.intt; }
}
