/* ID.java
 * Bryan Chadwick :: 2007
 * ID function class for BuiltIn Types */

package edu.neu.ccs.demeterf;

import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.lib.verbatim;

/** Combined ID Builder/Augmentor implementation. Provides default implementation
 *   for BuiltIn types that just returns the original. Methods can be overriden
 *   to implement other functionality */
public class ID extends FC{
    protected int combine(int i){ return i; }
    long combine(long l){ return l; }
    float combine(float f){ return f; }
    double combine(double d){ return d; }
    boolean combine(boolean b){ return b; }
    char combine(char c){ return c; }
    String combine(String s){ return s; }
    ident combine(ident id){ return id; }
    verbatim combine(verbatim v){ return v; }
}
